/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StaticViewResolver;
import org.springframework.test.web.servlet.setup.StubWebApplicationContext;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.servlet.view.DefaultRequestToViewNameTranslator;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

public class StandaloneMockMvcBuilder
extends AbstractMockMvcBuilder<StandaloneMockMvcBuilder> {
    private final List<Object> controllers;
    private @Nullable List<Object> controllerAdvice;
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private final List<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>();
    private @Nullable Validator validator;
    private @Nullable ContentNegotiationManager contentNegotiationManager;
    private @Nullable FormattingConversionService conversionService;
    private @Nullable List<HandlerExceptionResolver> handlerExceptionResolvers;
    private @Nullable Long asyncRequestTimeout;
    private @Nullable List<ViewResolver> viewResolvers;
    private LocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
    private @Nullable FlashMapManager flashMapManager;
    private boolean preferPathMatcher = false;
    private @Nullable PathPatternParser patternParser;
    private @Nullable Boolean removeSemicolonContent;
    private final Map<String, String> placeholderValues = new HashMap<String, String>();
    private Supplier<RequestMappingHandlerMapping> handlerMappingFactory = RequestMappingHandlerMapping::new;

    protected StandaloneMockMvcBuilder(Object ... controllers) {
        this.controllers = StandaloneMockMvcBuilder.instantiateIfNecessary(controllers);
    }

    private static List<Object> instantiateIfNecessary(Object[] specified) {
        ArrayList<Object> instances = new ArrayList<Object>(specified.length);
        for (Object obj : specified) {
            Object object;
            if (obj instanceof Class) {
                Class clazz = (Class)obj;
                object = BeanUtils.instantiateClass((Class)clazz);
            } else {
                object = obj;
            }
            instances.add(object);
        }
        return instances;
    }

    public StandaloneMockMvcBuilder setControllerAdvice(Object ... controllerAdvice) {
        this.controllerAdvice = StandaloneMockMvcBuilder.instantiateIfNecessary(controllerAdvice);
        return this;
    }

    public StandaloneMockMvcBuilder setMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        this.messageConverters = Arrays.asList(messageConverters);
        return this;
    }

    public StandaloneMockMvcBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public StandaloneMockMvcBuilder setConversionService(FormattingConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public StandaloneMockMvcBuilder addInterceptors(HandlerInterceptor ... interceptors) {
        this.addMappedInterceptors(null, interceptors);
        return this;
    }

    public StandaloneMockMvcBuilder addMappedInterceptors(String @Nullable [] pathPatterns, HandlerInterceptor ... interceptors) {
        for (HandlerInterceptor interceptor : interceptors) {
            this.mappedInterceptors.add(new MappedInterceptor(pathPatterns, null, interceptor));
        }
        return this;
    }

    public StandaloneMockMvcBuilder setContentNegotiationManager(ContentNegotiationManager manager) {
        this.contentNegotiationManager = manager;
        return this;
    }

    public StandaloneMockMvcBuilder setAsyncRequestTimeout(long timeout) {
        this.asyncRequestTimeout = timeout;
        return this;
    }

    public StandaloneMockMvcBuilder setCustomArgumentResolvers(HandlerMethodArgumentResolver ... argumentResolvers) {
        this.customArgumentResolvers = Arrays.asList(argumentResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setCustomReturnValueHandlers(HandlerMethodReturnValueHandler ... handlers) {
        this.customReturnValueHandlers = Arrays.asList(handlers);
        return this;
    }

    public StandaloneMockMvcBuilder setHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        this.handlerExceptionResolvers = exceptionResolvers;
        return this;
    }

    public StandaloneMockMvcBuilder setHandlerExceptionResolvers(HandlerExceptionResolver ... exceptionResolvers) {
        this.handlerExceptionResolvers = Arrays.asList(exceptionResolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setViewResolvers(ViewResolver ... resolvers) {
        this.viewResolvers = Arrays.asList(resolvers);
        return this;
    }

    public StandaloneMockMvcBuilder setSingleView(View view) {
        this.viewResolvers = Collections.singletonList(new StaticViewResolver(view));
        return this;
    }

    public StandaloneMockMvcBuilder setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    public StandaloneMockMvcBuilder setFlashMapManager(FlashMapManager flashMapManager) {
        this.flashMapManager = flashMapManager;
        return this;
    }

    public StandaloneMockMvcBuilder setPatternParser(@Nullable PathPatternParser parser) {
        this.patternParser = parser;
        this.preferPathMatcher = this.patternParser == null;
        return this;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public StandaloneMockMvcBuilder setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
        return this;
    }

    public StandaloneMockMvcBuilder addPlaceholderValue(String name, String value) {
        this.placeholderValues.put(name, value);
        return this;
    }

    public StandaloneMockMvcBuilder setCustomHandlerMapping(Supplier<RequestMappingHandlerMapping> factory) {
        this.handlerMappingFactory = factory;
        return this;
    }

    @Override
    protected WebApplicationContext initWebAppContext() {
        MockServletContext servletContext = new MockServletContext();
        StubWebApplicationContext wac = new StubWebApplicationContext(servletContext);
        this.registerMvcSingletons(wac);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, wac);
        return wac;
    }

    private void registerMvcSingletons(StubWebApplicationContext wac) {
        StandaloneConfiguration config = new StandaloneConfiguration();
        config.setApplicationContext((ApplicationContext)wac);
        ServletContext sc = wac.getServletContext();
        wac.addBeans(this.controllers);
        wac.addBeans(this.controllerAdvice);
        FormattingConversionService mvcConversionService = config.mvcConversionService();
        wac.addBean("mvcConversionService", mvcConversionService);
        ResourceUrlProvider resourceUrlProvider = config.mvcResourceUrlProvider();
        wac.addBean("mvcResourceUrlProvider", resourceUrlProvider);
        ContentNegotiationManager mvcContentNegotiationManager = config.mvcContentNegotiationManager();
        wac.addBean("mvcContentNegotiationManager", mvcContentNegotiationManager);
        Validator mvcValidator = config.mvcValidator();
        wac.addBean("mvcValidator", mvcValidator);
        RequestMappingHandlerMapping hm = config.getHandlerMapping(mvcConversionService, resourceUrlProvider);
        if (sc != null) {
            hm.setServletContext(sc);
        }
        hm.setApplicationContext((ApplicationContext)wac);
        hm.afterPropertiesSet();
        wac.addBean("requestMappingHandlerMapping", hm);
        RequestMappingHandlerAdapter ha = config.requestMappingHandlerAdapter(mvcContentNegotiationManager, mvcConversionService, mvcValidator);
        if (sc != null) {
            ha.setServletContext(sc);
        }
        ha.setApplicationContext((ApplicationContext)wac);
        ha.afterPropertiesSet();
        wac.addBean("requestMappingHandlerAdapter", ha);
        wac.addBean("handlerExceptionResolver", config.handlerExceptionResolver(mvcContentNegotiationManager));
        wac.addBeans(this.initViewResolvers(wac));
        wac.addBean("localeResolver", this.localeResolver);
        wac.addBean("viewNameTranslator", new DefaultRequestToViewNameTranslator());
        this.flashMapManager = new SessionFlashMapManager();
        wac.addBean("flashMapManager", this.flashMapManager);
        this.extendMvcSingletons(sc).forEach(wac::addBean);
    }

    private List<ViewResolver> initViewResolvers(WebApplicationContext wac) {
        this.viewResolvers = this.viewResolvers != null ? this.viewResolvers : Collections.singletonList(new InternalResourceViewResolver());
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof WebApplicationObjectSupport)) continue;
            WebApplicationObjectSupport support = (WebApplicationObjectSupport)viewResolver;
            support.setApplicationContext((ApplicationContext)wac);
        }
        return this.viewResolvers;
    }

    protected Map<String, Object> extendMvcSingletons(@Nullable ServletContext servletContext) {
        return Collections.emptyMap();
    }

    private class StandaloneConfiguration
    extends WebMvcConfigurationSupport {
        private StandaloneConfiguration() {
        }

        public RequestMappingHandlerMapping getHandlerMapping(FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
            RequestMappingHandlerMapping handlerMapping = StandaloneMockMvcBuilder.this.handlerMappingFactory.get();
            handlerMapping.setEmbeddedValueResolver((StringValueResolver)new StaticStringValueResolver(StandaloneMockMvcBuilder.this.placeholderValues));
            if (StandaloneMockMvcBuilder.this.patternParser == null && StandaloneMockMvcBuilder.this.preferPathMatcher) {
                handlerMapping.setPatternParser(null);
                if (StandaloneMockMvcBuilder.this.removeSemicolonContent != null) {
                    UrlPathHelper pathHelper = new UrlPathHelper();
                    pathHelper.setRemoveSemicolonContent(StandaloneMockMvcBuilder.this.removeSemicolonContent.booleanValue());
                    handlerMapping.setUrlPathHelper(pathHelper);
                }
            } else if (StandaloneMockMvcBuilder.this.patternParser != null) {
                handlerMapping.setPatternParser(StandaloneMockMvcBuilder.this.patternParser);
            }
            handlerMapping.setOrder(0);
            handlerMapping.setInterceptors(this.getInterceptors(mvcConversionService, mvcResourceUrlProvider));
            return handlerMapping;
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(StandaloneMockMvcBuilder.this.messageConverters);
        }

        protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.addAll(StandaloneMockMvcBuilder.this.customArgumentResolvers);
        }

        protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
            returnValueHandlers.addAll(StandaloneMockMvcBuilder.this.customReturnValueHandlers);
        }

        protected void addInterceptors(InterceptorRegistry registry) {
            for (MappedInterceptor interceptor : StandaloneMockMvcBuilder.this.mappedInterceptors) {
                InterceptorRegistration registration = registry.addInterceptor(interceptor.getInterceptor());
                if (interceptor.getIncludePathPatterns() == null) continue;
                registration.addPathPatterns(interceptor.getIncludePathPatterns());
            }
        }

        public ContentNegotiationManager mvcContentNegotiationManager() {
            return StandaloneMockMvcBuilder.this.contentNegotiationManager != null ? StandaloneMockMvcBuilder.this.contentNegotiationManager : super.mvcContentNegotiationManager();
        }

        public FormattingConversionService mvcConversionService() {
            return StandaloneMockMvcBuilder.this.conversionService != null ? StandaloneMockMvcBuilder.this.conversionService : super.mvcConversionService();
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            if (StandaloneMockMvcBuilder.this.asyncRequestTimeout != null) {
                configurer.setDefaultTimeout(StandaloneMockMvcBuilder.this.asyncRequestTimeout.longValue());
            }
        }

        public Validator mvcValidator() {
            Validator mvcValidator;
            Validator validator = mvcValidator = StandaloneMockMvcBuilder.this.validator != null ? StandaloneMockMvcBuilder.this.validator : super.mvcValidator();
            if (mvcValidator instanceof InitializingBean) {
                InitializingBean initializingBean = (InitializingBean)mvcValidator;
                try {
                    initializingBean.afterPropertiesSet();
                }
                catch (Exception ex) {
                    throw new BeanInitializationException("Failed to initialize Validator", (Throwable)ex);
                }
            }
            return mvcValidator;
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            if (StandaloneMockMvcBuilder.this.handlerExceptionResolvers == null) {
                return;
            }
            for (HandlerExceptionResolver resolver : StandaloneMockMvcBuilder.this.handlerExceptionResolvers) {
                if (resolver instanceof ApplicationContextAware) {
                    ApplicationContextAware applicationContextAware = (ApplicationContextAware)resolver;
                    ApplicationContext applicationContext = this.getApplicationContext();
                    if (applicationContext != null) {
                        applicationContextAware.setApplicationContext(applicationContext);
                    }
                }
                if (resolver instanceof InitializingBean) {
                    InitializingBean initializingBean = (InitializingBean)resolver;
                    try {
                        initializingBean.afterPropertiesSet();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Failure from afterPropertiesSet", ex);
                    }
                }
                exceptionResolvers.add(resolver);
            }
        }
    }

    private static class StaticStringValueResolver
    implements StringValueResolver {
        private final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", null, false);
        private final PropertyPlaceholderHelper.PlaceholderResolver resolver = values::get;

        public StaticStringValueResolver(Map<String, String> values) {
        }

        public String resolveStringValue(String strVal) throws BeansException {
            return this.helper.replacePlaceholders(strVal, this.resolver);
        }
    }
}

