/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.servlet.request.AbstractMockHttpServletRequestBuilder;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractMockMultipartHttpServletRequestBuilder<B extends AbstractMockMultipartHttpServletRequestBuilder<B>>
extends AbstractMockHttpServletRequestBuilder<B> {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();
    private final MultiValueMap<String, Part> parts = new LinkedMultiValueMap();

    protected AbstractMockMultipartHttpServletRequestBuilder(HttpMethod httpMethod) {
        super(httpMethod);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public B file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return (B)((AbstractMockMultipartHttpServletRequestBuilder)this.self());
    }

    public B file(MockMultipartFile file) {
        this.files.add(file);
        return (B)((AbstractMockMultipartHttpServletRequestBuilder)this.self());
    }

    public B part(Part ... parts) {
        Assert.notEmpty((Object[])parts, (String)"'parts' must not be empty");
        for (Part part : parts) {
            this.parts.add((Object)part.getName(), (Object)part);
        }
        return (B)((AbstractMockMultipartHttpServletRequestBuilder)this.self());
    }

    @Override
    public Object merge(@Nullable Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof AbstractMockHttpServletRequestBuilder) {
            super.merge(parent);
            if (parent instanceof AbstractMockMultipartHttpServletRequestBuilder) {
                AbstractMockMultipartHttpServletRequestBuilder parentBuilder = (AbstractMockMultipartHttpServletRequestBuilder)parent;
                this.files.addAll(parentBuilder.files);
                parentBuilder.parts.keySet().forEach(name -> this.parts.putIfAbsent(name, (Object)((List)parentBuilder.parts.get(name))));
            }
        } else {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        return this;
    }

    @Override
    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request = new MockMultipartHttpServletRequest(servletContext);
        Charset defaultCharset = request.getCharacterEncoding() != null ? Charset.forName(request.getCharacterEncoding()) : StandardCharsets.UTF_8;
        this.files.forEach(request::addFile);
        this.parts.values().stream().flatMap(Collection::stream).forEach(part -> {
            request.addPart((Part)part);
            try {
                String name = part.getName();
                String filename = part.getSubmittedFileName();
                InputStream is = part.getInputStream();
                if (filename != null) {
                    request.addFile(new MockMultipartFile(name, filename, part.getContentType(), is));
                } else {
                    InputStreamReader reader = new InputStreamReader(is, this.getCharsetOrDefault((Part)part, defaultCharset));
                    String value = FileCopyUtils.copyToString((Reader)reader);
                    request.addParameter(part.getName(), value);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to read content for part " + part.getName(), ex);
            }
        });
        return request;
    }

    private Charset getCharsetOrDefault(Part part, Charset defaultCharset) {
        MediaType mediaType;
        if (part.getContentType() != null && (mediaType = MediaType.parseMediaType((String)part.getContentType())).getCharset() != null) {
            return mediaType.getCharset();
        }
        return defaultCharset;
    }
}

