/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.http.Cookie;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jspecify.annotations.Nullable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MockCookie
extends Cookie {
    private static final long serialVersionUID = 4312531139502726325L;
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String COMMENT = "Comment";
    private static final String SECURE = "Secure";
    private static final String HTTP_ONLY = "HttpOnly";
    private static final String PARTITIONED = "Partitioned";
    private static final String SAME_SITE = "SameSite";
    private static final String MAX_AGE = "Max-Age";
    private static final String EXPIRES = "Expires";
    private @Nullable ZonedDateTime expires;

    public MockCookie(String name, String value) {
        super(name, value);
    }

    public void setExpires(@Nullable ZonedDateTime expires) {
        this.setAttribute(EXPIRES, expires != null ? expires.format(DateTimeFormatter.RFC_1123_DATE_TIME) : null);
    }

    public @Nullable ZonedDateTime getExpires() {
        return this.expires;
    }

    public void setSameSite(@Nullable String sameSite) {
        this.setAttribute(SAME_SITE, sameSite);
    }

    public @Nullable String getSameSite() {
        return this.getAttribute(SAME_SITE);
    }

    public void setPartitioned(boolean partitioned) {
        if (partitioned) {
            this.setAttribute(PARTITIONED, "");
        } else {
            this.setAttribute(PARTITIONED, null);
        }
    }

    public boolean isPartitioned() {
        return this.getAttribute(PARTITIONED) != null;
    }

    public static MockCookie parse(String setCookieHeader) {
        Assert.notNull((Object)setCookieHeader, (String)"Set-Cookie header must not be null");
        String[] cookieParts = setCookieHeader.split("\\s*=\\s*", 2);
        Assert.isTrue((cookieParts.length == 2 ? 1 : 0) != 0, () -> "Invalid Set-Cookie header '" + setCookieHeader + "'");
        String name = cookieParts[0];
        String[] valueAndAttributes = cookieParts[1].split("\\s*;\\s*", 2);
        String value = valueAndAttributes[0];
        String[] attributes = valueAndAttributes.length > 1 ? valueAndAttributes[1].split("\\s*;\\s*") : new String[]{};
        MockCookie cookie = new MockCookie(name, value);
        for (String attribute : attributes) {
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)DOMAIN)) {
                cookie.setDomain(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)MAX_AGE)) {
                cookie.setMaxAge(Integer.parseInt(MockCookie.extractAttributeValue(attribute, setCookieHeader)));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)EXPIRES)) {
                try {
                    cookie.setExpires(ZonedDateTime.parse(MockCookie.extractAttributeValue(attribute, setCookieHeader), DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (DateTimeException dateTimeException) {}
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)PATH)) {
                cookie.setPath(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)SECURE)) {
                cookie.setSecure(true);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)HTTP_ONLY)) {
                cookie.setHttpOnly(true);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)SAME_SITE)) {
                cookie.setSameSite(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)COMMENT)) {
                cookie.setComment(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (attribute.isEmpty()) continue;
            cookie.setAttribute(attribute, MockCookie.extractOptionalAttributeValue(attribute, setCookieHeader));
        }
        return cookie;
    }

    private static String extractAttributeValue(String attribute, String header) {
        String[] nameAndValue = attribute.split("=");
        Assert.isTrue((nameAndValue.length == 2 ? 1 : 0) != 0, () -> "No value in attribute '" + nameAndValue[0] + "' for Set-Cookie header '" + header + "'");
        return nameAndValue[1];
    }

    private static String extractOptionalAttributeValue(String attribute, String header) {
        String[] nameAndValue = attribute.split("=");
        return nameAndValue.length == 2 ? nameAndValue[1] : "";
    }

    public void setAttribute(String name, @Nullable String value) {
        if (EXPIRES.equalsIgnoreCase(name)) {
            this.expires = value != null ? ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
        }
        super.setAttribute(name, value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.getName()).append("value", (Object)this.getValue()).append(PATH, (Object)this.getPath()).append(DOMAIN, (Object)this.getDomain()).append("Version", this.getVersion()).append(COMMENT, (Object)this.getComment()).append(SECURE, this.getSecure()).append(HTTP_ONLY, this.isHttpOnly()).append(PARTITIONED, this.isPartitioned()).append(SAME_SITE, (Object)this.getSameSite()).append(MAX_AGE, this.getMaxAge()).append(EXPIRES, (Object)this.getAttribute(EXPIRES)).toString();
    }
}

