/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.RequestExpectation;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;

public class DefaultRequestExpectation
implements RequestExpectation {
    private final RequestCount requestCount;
    private final List<RequestMatcher> requestMatchers = new LinkedList<RequestMatcher>();
    private ResponseCreator responseCreator;

    public DefaultRequestExpectation(ExpectedCount expectedCount, RequestMatcher requestMatcher) {
        Assert.notNull((Object)expectedCount, (String)"'expectedCount' is required");
        Assert.notNull((Object)requestMatcher, (String)"'requestMatcher' is required");
        this.requestCount = new RequestCount(expectedCount);
        this.requestMatchers.add(requestMatcher);
    }

    protected RequestCount getRequestCount() {
        return this.requestCount;
    }

    protected List<RequestMatcher> getRequestMatchers() {
        return this.requestMatchers;
    }

    protected ResponseCreator getResponseCreator() {
        return this.responseCreator;
    }

    @Override
    public ResponseActions andExpect(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"RequestMatcher is required");
        this.requestMatchers.add(requestMatcher);
        return this;
    }

    @Override
    public void andRespond(ResponseCreator responseCreator) {
        Assert.notNull((Object)responseCreator, (String)"ResponseCreator is required");
        this.responseCreator = responseCreator;
    }

    @Override
    public void match(ClientHttpRequest request) throws IOException {
        for (RequestMatcher matcher : this.getRequestMatchers()) {
            matcher.match(request);
        }
    }

    @Override
    public ClientHttpResponse createResponse(ClientHttpRequest request) throws IOException {
        ResponseCreator responseCreator = this.getResponseCreator();
        if (responseCreator == null) {
            throw new IllegalStateException("createResponse called before ResponseCreator was set");
        }
        this.getRequestCount().incrementAndValidate();
        return responseCreator.createResponse(request);
    }

    @Override
    public boolean hasRemainingCount() {
        return this.getRequestCount().hasRemainingCount();
    }

    @Override
    public boolean isSatisfied() {
        return this.getRequestCount().isSatisfied();
    }

    protected static class RequestCount {
        private final ExpectedCount expectedCount;
        private int matchedRequestCount;

        public RequestCount(ExpectedCount expectedCount) {
            this.expectedCount = expectedCount;
        }

        public ExpectedCount getExpectedCount() {
            return this.expectedCount;
        }

        public int getMatchedRequestCount() {
            return this.matchedRequestCount;
        }

        public void incrementAndValidate() {
            ++this.matchedRequestCount;
            if (this.getMatchedRequestCount() > this.getExpectedCount().getMaxCount()) {
                throw new AssertionError((Object)"No more calls expected.");
            }
        }

        public boolean hasRemainingCount() {
            return this.getMatchedRequestCount() < this.getExpectedCount().getMaxCount();
        }

        public boolean isSatisfied() {
            return this.getMatchedRequestCount() >= this.getExpectedCount().getMinCount();
        }
    }
}

