/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Statement;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.DefaultDatabaseClient;
import org.springframework.r2dbc.core.ExecuteFunction;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.r2dbc.core.binding.BindMarkersFactoryResolver;
import org.springframework.util.Assert;

class DefaultDatabaseClientBuilder
implements DatabaseClient.Builder {
    private @Nullable BindMarkersFactory bindMarkers;
    private @Nullable ConnectionFactory connectionFactory;
    private ExecuteFunction executeFunction = Statement::execute;
    private boolean namedParameters = true;

    DefaultDatabaseClientBuilder() {
    }

    @Override
    public DatabaseClient.Builder bindMarkers(BindMarkersFactory bindMarkers) {
        Assert.notNull((Object)bindMarkers, (String)"BindMarkersFactory must not be null");
        this.bindMarkers = bindMarkers;
        return this;
    }

    @Override
    public DatabaseClient.Builder connectionFactory(ConnectionFactory factory) {
        Assert.notNull((Object)factory, (String)"ConnectionFactory must not be null");
        this.connectionFactory = factory;
        return this;
    }

    @Override
    public DatabaseClient.Builder executeFunction(ExecuteFunction executeFunction) {
        Assert.notNull((Object)executeFunction, (String)"ExecuteFunction must not be null");
        this.executeFunction = executeFunction;
        return this;
    }

    @Override
    public DatabaseClient.Builder namedParameters(boolean enabled) {
        this.namedParameters = enabled;
        return this;
    }

    @Override
    public DatabaseClient build() {
        Assert.notNull((Object)this.connectionFactory, (String)"ConnectionFactory must not be null");
        BindMarkersFactory bindMarkers = this.bindMarkers;
        if (bindMarkers == null) {
            bindMarkers = this.namedParameters ? BindMarkersFactoryResolver.resolve(this.connectionFactory) : BindMarkersFactory.anonymous("?");
        }
        return new DefaultDatabaseClient(bindMarkers, this.connectionFactory, this.executeFunction, this.namedParameters);
    }

    @Override
    public DatabaseClient.Builder apply(Consumer<DatabaseClient.Builder> builderConsumer) {
        Assert.notNull(builderConsumer, (String)"BuilderConsumer must not be null");
        builderConsumer.accept(this);
        return this;
    }
}

