/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.core.JmsClient;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.JmsAccessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

class DefaultJmsClient
implements JmsClient {
    private final JmsOperations jmsTemplate;
    private final @Nullable MessageConverter messageConverter;

    public DefaultJmsClient(ConnectionFactory connectionFactory, @Nullable MessageConverter messageConverter) {
        this.jmsTemplate = new JmsTemplate(connectionFactory);
        this.messageConverter = messageConverter;
    }

    public DefaultJmsClient(JmsOperations jmsTemplate, @Nullable MessageConverter messageConverter) {
        Assert.notNull((Object)jmsTemplate, (String)"JmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
        this.messageConverter = messageConverter;
    }

    @Override
    public JmsClient.OperationSpec destination(Destination destination) {
        return new DefaultOperationSpec(destination);
    }

    @Override
    public JmsClient.OperationSpec destination(String destinationName) {
        return new DefaultOperationSpec(destinationName);
    }

    private JmsMessagingTemplate newDelegate() {
        JmsMessagingTemplate delegate = new JmsMessagingTemplate(this.jmsTemplate);
        MessageConverter converter = this.messageConverter;
        if (converter != null) {
            delegate.setMessageConverter(converter);
        }
        return delegate;
    }

    private class DefaultOperationSpec
    implements JmsClient.OperationSpec {
        private final JmsMessagingTemplate delegate;
        private @Nullable JmsTemplate customTemplate;

        public DefaultOperationSpec(Destination destination) {
            this.delegate = DefaultJmsClient.this.newDelegate();
            this.delegate.setDefaultDestination(destination);
        }

        public DefaultOperationSpec(String destinationName) {
            this.delegate = DefaultJmsClient.this.newDelegate();
            this.delegate.setDefaultDestinationName(destinationName);
        }

        private JmsTemplate enforceCustomTemplate(boolean qos) {
            if (this.customTemplate == null) {
                JmsOperations jmsOperations = DefaultJmsClient.this.jmsTemplate;
                if (!(jmsOperations instanceof JmsAccessor)) {
                    throw new IllegalStateException("Needs to be bound to a JmsAccessor for custom settings support: " + String.valueOf(jmsOperations));
                }
                JmsAccessor original = (JmsAccessor)((Object)jmsOperations);
                this.customTemplate = new JmsTemplate(original);
                this.delegate.setJmsTemplate(this.customTemplate);
            }
            if (qos) {
                this.customTemplate.setExplicitQosEnabled(true);
            }
            return this.customTemplate;
        }

        @Override
        public JmsClient.OperationSpec withReceiveTimeout(long receiveTimeout) {
            this.enforceCustomTemplate(false).setReceiveTimeout(receiveTimeout);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withDeliveryDelay(long deliveryDelay) {
            this.enforceCustomTemplate(false).setDeliveryDelay(deliveryDelay);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withDeliveryPersistent(boolean persistent) {
            this.enforceCustomTemplate(true).setDeliveryPersistent(persistent);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withPriority(int priority) {
            this.enforceCustomTemplate(true).setPriority(priority);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withTimeToLive(long timeToLive) {
            this.enforceCustomTemplate(true).setTimeToLive(timeToLive);
            return this;
        }

        @Override
        public void send(Message<?> message) throws MessagingException {
            this.delegate.send(message);
        }

        @Override
        public void send(Object payload) throws MessagingException {
            this.delegate.convertAndSend(payload);
        }

        @Override
        public void send(Object payload, Map<String, Object> headers) throws MessagingException {
            this.delegate.convertAndSend(payload, headers);
        }

        @Override
        public Optional<Message<?>> receive() throws MessagingException {
            return Optional.ofNullable(this.delegate.receive());
        }

        @Override
        public <T> Optional<T> receive(Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.receiveAndConvert(targetClass));
        }

        @Override
        public Optional<Message<?>> receive(String messageSelector) throws MessagingException {
            return Optional.ofNullable(this.delegate.receiveSelected(messageSelector));
        }

        @Override
        public <T> Optional<T> receive(String messageSelector, Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.receiveSelectedAndConvert(messageSelector, targetClass));
        }

        @Override
        public Optional<Message<?>> sendAndReceive(Message<?> requestMessage) throws MessagingException {
            return Optional.ofNullable(this.delegate.sendAndReceive(requestMessage));
        }

        @Override
        public <T> Optional<T> sendAndReceive(Object request, Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.convertSendAndReceive(request, targetClass));
        }

        @Override
        public <T> Optional<T> sendAndReceive(Object request, Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.convertSendAndReceive(request, headers, targetClass));
        }
    }
}

