/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private Class<? extends Annotation> requiredAnnotationType = Required.class;

    public void setRequiredAnnotationType(Class<? extends Annotation> requiredAnnotationType) {
        Assert.notNull(requiredAnnotationType, (String)"requiredAnnotationType must not be null");
        this.requiredAnnotationType = requiredAnnotationType;
    }

    protected Class<? extends Annotation> getRequiredAnnotationType() {
        return this.requiredAnnotationType;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        Class<?> targetClass = bean.getClass();
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(targetClass);
        ArrayList<String> invalidProperties = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!this.isRequiredProperty(propertyDescriptor) || pvs.contains(propertyDescriptor.getName())) continue;
            invalidProperties.add(propertyDescriptor.getName());
        }
        if (!invalidProperties.isEmpty()) {
            throw new BeanInitializationException(this.buildExceptionMessage(invalidProperties, beanName));
        }
        return pvs;
    }

    protected boolean isRequiredProperty(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return setter != null && AnnotationUtils.getAnnotation((Method)setter, this.getRequiredAnnotationType()) != null;
    }

    private String buildExceptionMessage(List<String> invalidProperties, String beanName) {
        StringBuilder sb = new StringBuilder();
        int size = invalidProperties.size();
        sb.append(size == 1 ? "Property" : "Properties");
        for (int i = 0; i < size; ++i) {
            String propertyName = invalidProperties.get(i);
            if (i > 0) {
                if (i == size - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '");
            sb.append(propertyName);
            sb.append('\'');
        }
        sb.append(size == 1 ? " is required" : " are required");
        sb.append(" for bean '");
        sb.append(beanName);
        sb.append("'.");
        return sb.toString();
    }
}

