/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.SingletonMetadataAwareAspectInstanceFactory;
import org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator;
import org.springframework.aop.aspectj.autoproxy.PrototypeAspectInstanceFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJAutoProxyCreator
extends AspectJInvocationContextExposingAdvisorAutoProxyCreator {
    private static final long serialVersionUID = -3347584141231774337L;
    private static final Log staticLogger = LogFactory.getLog(AspectJAutoProxyCreator.class);
    private static final String ORDER_PROPERTY = "order";
    private AspectJAdvisorFactory aspectJAdvisorFactory = new ReflectiveAspectJAdvisorFactory();

    public static List<Advisor> createAspectJAdvisors(AspectJAdvisorFactory aspectJAdvisorFactory, BeanFactory beanFactory) throws BeansException, IllegalStateException {
        String[] beanDefinitionNames;
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String beanName : beanDefinitionNames = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)beanFactory))) {
            Class beanType = beanFactory.getType(beanName);
            if (beanType == null || !aspectJAdvisorFactory.isAspect(beanType)) continue;
            AspectMetadata amd = new AspectMetadata(beanType, beanName);
            if (amd.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
                Object beanInstance = beanFactory.getBean(beanName);
                List<Advisor> classAdvisors = aspectJAdvisorFactory.getAdvisors(new SingletonMetadataAwareAspectInstanceFactory(beanInstance, beanName));
                AspectJAutoProxyCreator.setAdvisorOrderIfNecessary(classAdvisors, beanInstance);
                staticLogger.debug((Object)("Found " + classAdvisors.size() + " AspectJ advice methods"));
                advisors.addAll(classAdvisors);
                continue;
            }
            if (beanFactory.isSingleton(beanName)) {
                throw new IllegalArgumentException("Bean with name '" + beanName + "' is a singleton, but aspect instantiation model is not singleton");
            }
            List<Advisor> classAdvisors = aspectJAdvisorFactory.getAdvisors(new PrototypeAspectInstanceFactory(beanFactory, beanName));
            AspectJAutoProxyCreator.setAdvisorOrderIfNecessary(classAdvisors, beanFactory, beanName);
            staticLogger.debug((Object)("Found " + classAdvisors.size() + " AspectJ advice methods in bean with name '" + beanName + "'"));
            advisors.addAll(classAdvisors);
        }
        return advisors;
    }

    private static void setAdvisorOrderIfNecessary(List<Advisor> advisors, Object beanInstance) {
        if (beanInstance instanceof Ordered) {
            int order = ((Ordered)beanInstance).getOrder();
            for (Advisor advisor : advisors) {
                if (!(advisor instanceof InstantiationModelAwarePointcutAdvisor)) continue;
                ((InstantiationModelAwarePointcutAdvisor)advisor).setOrder(order);
            }
        }
    }

    private static void setAdvisorOrderIfNecessary(List<Advisor> advisors, BeanFactory beanFactory, String beanName) {
        BeanDefinition beanDef;
        MutablePropertyValues mpvs;
        if (beanFactory instanceof ConfigurableListableBeanFactory && (mpvs = (beanDef = ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName)).getPropertyValues()).contains(ORDER_PROPERTY)) {
            int order = Integer.parseInt((String)mpvs.getPropertyValue(ORDER_PROPERTY).getValue());
            for (Advisor advisor : advisors) {
                if (!(advisor instanceof InstantiationModelAwarePointcutAdvisor)) continue;
                ((InstantiationModelAwarePointcutAdvisor)advisor).setOrder(order);
            }
        }
    }

    public AspectJAutoProxyCreator() {
        this.setProxyTargetClass(true);
    }

    public void setAspectJAdvisorFactory(AspectJAdvisorFactory aspectJAdvisorFactory) {
        this.aspectJAdvisorFactory = aspectJAdvisorFactory;
    }

    @Override
    protected List findCandidateAdvisors() {
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        advisors.addAll(super.findCandidateAdvisors());
        advisors.addAll(AspectJAutoProxyCreator.createAspectJAdvisors(this.aspectJAdvisorFactory, this.getBeanFactory()));
        return advisors;
    }
}

