/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.springframework.shell.commands.OsOperations;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.stereotype.Component;

@Component
public class OsOperationsImpl
implements OsOperations {
    private static final Logger LOGGER = HandlerUtils.getLogger(OsOperationsImpl.class);

    @Override
    public void executeCommand(String command) throws IOException {
        File root = new File(".");
        Process p = Runtime.getRuntime().exec(command, null, root);
        InputStreamReader input = new InputStreamReader(p.getInputStream());
        InputStreamReader errors = new InputStreamReader(p.getErrorStream());
        for (String line : IOUtils.readLines((Reader)input)) {
            if (line.startsWith("[ERROR]")) {
                LOGGER.severe(line);
                continue;
            }
            if (line.startsWith("[WARNING]")) {
                LOGGER.warning(line);
                continue;
            }
            LOGGER.info(line);
        }
        for (String line : IOUtils.readLines((Reader)errors)) {
            if (line.startsWith("[ERROR]")) {
                LOGGER.severe(line);
                continue;
            }
            if (line.startsWith("[WARNING]")) {
                LOGGER.warning(line);
                continue;
            }
            LOGGER.info(line);
        }
        p.getOutputStream().close();
        try {
            if (p.waitFor() != 0) {
                LOGGER.warning("The command '" + command + "' did not complete successfully");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }
}

