/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.springframework.shell.CommandLine;
import org.springframework.shell.support.logging.HandlerUtils;

public class SimpleShellCommandLineOptions {
    private static final Logger LOGGER = HandlerUtils.getLogger(SimpleShellCommandLineOptions.class);
    public static final int DEFAULT_HISTORY_SIZE = 3000;
    String[] executeThenQuit = null;
    Map<String, String> extraSystemProperties = new HashMap<String, String>();
    int historySize = 3000;
    boolean disableCommands;

    public static CommandLine parseCommandLine(String[] args) throws IOException {
        if (args == null) {
            args = new String[]{};
        }
        SimpleShellCommandLineOptions options = new SimpleShellCommandLineOptions();
        ArrayList<String> commands = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("--profiles")) {
                try {
                    String profiles = args[i++];
                    options.extraSystemProperties.put("spring.profiles.active", profiles);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.warning("No value specified for --profiles option");
                }
                continue;
            }
            if (arg.equals("--cmdfile")) {
                try {
                    File f = new File(args[i++]);
                    commands.addAll(FileUtils.readLines((File)f));
                }
                catch (IOException e) {
                    LOGGER.warning("Could not read lines from command file: " + e.getMessage());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.warning("No value specified for --cmdfile option");
                }
                continue;
            }
            if (arg.equals("--histsize")) {
                try {
                    String histSizeArg = args[i++];
                    int histSize = Integer.parseInt(histSizeArg);
                    if (histSize <= 0) {
                        LOGGER.warning("histsize option must be > 0, using default value of 3000");
                        continue;
                    }
                    options.historySize = histSize;
                }
                catch (NumberFormatException e) {
                    LOGGER.warning("Unable to parse histsize value to an integer ");
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    LOGGER.warning("No value specified for --histsize option");
                }
                continue;
            }
            if (arg.equals("--disableInternalCommands")) {
                options.disableCommands = true;
                continue;
            }
            if (arg.equals("--help")) {
                SimpleShellCommandLineOptions.printUsage();
                System.exit(0);
                continue;
            }
            --i;
            break;
        }
        StringBuilder sb = new StringBuilder();
        while (i < args.length) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(args[i]);
            ++i;
        }
        if (sb.length() > 0) {
            String[] cmdLineCommands;
            for (String s : cmdLineCommands = sb.toString().split(";")) {
                commands.add(s.trim());
            }
        }
        if (commands.size() > 0) {
            options.executeThenQuit = commands.toArray(new String[commands.size()]);
        }
        for (Map.Entry<String, String> entry : options.extraSystemProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
        return new CommandLine(args, options.historySize, options.executeThenQuit, options.disableCommands);
    }

    private static void printUsage() {
        System.out.println("Usage:  --help --histsize [size] --cmdfile [file name] --profiles [comma-separated list of profile names]");
    }
}

