/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.logging;

import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.springframework.shell.support.logging.DeferredLogHandler;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerUtils {
    public static Logger getLogger(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class required");
        String name = clazz.getName();
        Logger logger = Logger.getLogger(name);
        if (logger.getLevel() == null && name.startsWith("org.springframework.shell")) {
            logger.setLevel(Level.FINE);
        }
        return logger;
    }

    public static int wrapWithDeferredLogHandler(Logger logger, Level fallbackSeverity) {
        Assert.notNull((Object)logger, (String)"Logger is required");
        Assert.notNull((Object)fallbackSeverity, (String)"Fallback severity is required");
        ArrayList<DeferredLogHandler> newHandlers = new ArrayList<DeferredLogHandler>();
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                logger.removeHandler(h);
                newHandlers.add(new DeferredLogHandler(h, fallbackSeverity));
            }
        }
        if (newHandlers.isEmpty()) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    return record.getMessage() + OsUtils.LINE_SEPARATOR;
                }
            });
            newHandlers.add(new DeferredLogHandler(consoleHandler, fallbackSeverity));
        }
        for (DeferredLogHandler h : newHandlers) {
            logger.addHandler(h);
        }
        return newHandlers.size();
    }

    public static int registerTargetHandler(Logger logger, Handler target) {
        Assert.notNull((Object)logger, (String)"Logger is required");
        Assert.notNull((Object)target, (String)"Target handler is required");
        int replaced = 0;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                if (!(h instanceof DeferredLogHandler)) continue;
                ++replaced;
                DeferredLogHandler defLogger = (DeferredLogHandler)h;
                defLogger.setTargetHandler(target);
            }
        }
        return replaced;
    }

    public static int flushAllHandlers(Logger logger) {
        Assert.notNull((Object)logger, (String)"Logger is required");
        int flushed = 0;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                ++flushed;
                h.flush();
            }
        }
        return flushed;
    }
}

