/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test;

import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.springframework.shell.test.ShellWriteSequence;

class JLineShellWriteSequence
implements ShellWriteSequence {
    private final Terminal terminal;
    private final StringBuilder buf = new StringBuilder();

    JLineShellWriteSequence(Terminal terminal) {
        this.terminal = terminal;
    }

    @Override
    public ShellWriteSequence carriageReturn() {
        this.buf.append(KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.carriage_return));
        return this;
    }

    @Override
    public ShellWriteSequence clearScreen() {
        String ansiClearScreen = KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.clear_screen);
        this.buf.append(ansiClearScreen);
        return this;
    }

    @Override
    public ShellWriteSequence ctrl(char c) {
        String ctrl = KeyMap.ctrl((char)c);
        this.buf.append(ctrl);
        return this;
    }

    @Override
    public ShellWriteSequence command(String command) {
        this.text(command);
        return this.carriageReturn();
    }

    @Override
    public ShellWriteSequence cr() {
        return this.carriageReturn();
    }

    @Override
    public ShellWriteSequence keyUp() {
        this.buf.append(KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up));
        return this;
    }

    @Override
    public ShellWriteSequence keyDown() {
        this.buf.append(KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down));
        return this;
    }

    @Override
    public ShellWriteSequence keyLeft() {
        this.buf.append(KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        return this;
    }

    @Override
    public ShellWriteSequence keyRight() {
        this.buf.append(KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        return this;
    }

    @Override
    public ShellWriteSequence text(String text) {
        this.buf.append(text);
        return this;
    }

    @Override
    public ShellWriteSequence space() {
        return this.text(" ");
    }

    @Override
    public String build() {
        return this.buf.toString();
    }
}

