/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.util;

import java.lang.reflect.Array;
import java.util.BitSet;

public class Util {
    public static <T> T[] copyOf(T[] original, int newLength) {
        Class<?> type = original.getClass().getComponentType();
        Object[] newArr = (Object[])Array.newInstance(type, newLength);
        System.arraycopy(original, 0, newArr, 0, Math.min(original.length, newLength));
        return newArr;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] newArr = new int[newLength];
        System.arraycopy(original, 0, newArr, 0, Math.min(original.length, newLength));
        return newArr;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] newArr = new char[newLength];
        System.arraycopy(original, 0, newArr, 0, Math.min(original.length, newLength));
        return newArr;
    }

    public static void bitsetCopy(BitSet src, int srcOffset, BitSet dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest.set(destOffset + i, src.get(srcOffset + i));
        }
    }

    public static String trimTrailing(String string) {
        int index;
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        return string.substring(0, index + 1);
    }

    public static boolean containsIgnoreCase(String where, String what) {
        return Util.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static int indexOfIgnoreCase(String where, String what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!Util.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !Util.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && Util.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || Util.toUpperCase(a) == Util.toUpperCase(b) || Util.toLowerCase(a) == Util.toLowerCase(b);
    }

    private static char toLowerCase(char b) {
        return Character.toLowerCase(b);
    }

    private static char toUpperCase(char a) {
        return Character.toUpperCase(a);
    }
}

