/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.test.jediterm.terminal.Terminal;
import org.springframework.shell.test.jediterm.terminal.TerminalDisplay;
import org.springframework.shell.test.jediterm.terminal.TerminalStarter;
import org.springframework.shell.test.jediterm.terminal.TextStyle;
import org.springframework.shell.test.jediterm.terminal.TtyBasedArrayDataStream;
import org.springframework.shell.test.jediterm.terminal.TtyConnector;
import org.springframework.shell.test.jediterm.terminal.model.JediTerminal;
import org.springframework.shell.test.jediterm.terminal.model.StyleState;
import org.springframework.shell.test.jediterm.terminal.model.TerminalTextBuffer;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalPanel;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalPanelListener;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalSession;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalWidget;

public class JediTermWidget
implements TerminalSession,
TerminalWidget {
    private static final Logger log = LoggerFactory.getLogger(JediTermWidget.class);
    private final TerminalPanel terminalPanel;
    private final JediTerminal terminal;
    private final AtomicBoolean sessionRunning = new AtomicBoolean();
    private TtyConnector ttyConnector;
    private TerminalStarter terminalStarter;
    private Thread emuThread;

    public JediTermWidget() {
        this(80, 24);
    }

    public JediTermWidget(int columns, int lines) {
        StyleState styleState = this.createDefaultStyle();
        TerminalTextBuffer terminalTextBuffer = new TerminalTextBuffer(columns, lines, styleState, 5000);
        this.terminalPanel = this.createTerminalPanel(styleState, terminalTextBuffer);
        this.terminal = new JediTerminal(this.terminalPanel, terminalTextBuffer, styleState);
        this.terminalPanel.setCoordAccessor(this.terminal);
        this.sessionRunning.set(false);
    }

    protected StyleState createDefaultStyle() {
        StyleState styleState = new StyleState();
        styleState.setDefaultStyle(new TextStyle());
        return styleState;
    }

    protected TerminalPanel createTerminalPanel(StyleState styleState, TerminalTextBuffer terminalTextBuffer) {
        return new TerminalPanel(terminalTextBuffer, styleState);
    }

    @Override
    public TerminalDisplay getTerminalDisplay() {
        return this.getTerminalPanel();
    }

    public TerminalPanel getTerminalPanel() {
        return this.terminalPanel;
    }

    public void setTtyConnector(TtyConnector ttyConnector) {
        this.ttyConnector = ttyConnector;
        this.terminalStarter = this.createTerminalStarter(this.terminal, ttyConnector);
        this.terminalPanel.setTerminalStarter(this.terminalStarter);
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        TtyBasedArrayDataStream ttyBasedArrayDataStream = new TtyBasedArrayDataStream(connector);
        return new TerminalStarter(terminal, connector, ttyBasedArrayDataStream);
    }

    @Override
    public TtyConnector getTtyConnector() {
        return this.ttyConnector;
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public String getSessionName() {
        if (this.ttyConnector != null) {
            return this.ttyConnector.getName();
        }
        return "Session";
    }

    @Override
    public void start() {
        if (!this.sessionRunning.get()) {
            this.emuThread = new Thread(new EmulatorTask());
            this.emuThread.start();
        } else {
            log.error("Should not try to start session again at this point... ");
        }
    }

    public void stop() {
        if (this.sessionRunning.get() && this.emuThread != null) {
            this.emuThread.interrupt();
        }
    }

    public boolean isSessionRunning() {
        return this.sessionRunning.get();
    }

    @Override
    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.terminalPanel.getTerminalTextBuffer();
    }

    @Override
    public boolean canOpenSession() {
        return !this.isSessionRunning();
    }

    @Override
    public void setTerminalPanelListener(TerminalPanelListener terminalPanelListener) {
        this.terminalPanel.setTerminalPanelListener(terminalPanelListener);
    }

    @Override
    public TerminalSession getCurrentSession() {
        return this;
    }

    @Override
    public JediTermWidget createTerminalSession(TtyConnector ttyConnector) {
        this.setTtyConnector(ttyConnector);
        return this;
    }

    @Override
    public void close() {
        this.stop();
        if (this.terminalStarter != null) {
            this.terminalStarter.close();
        }
        this.terminalPanel.dispose();
    }

    @Override
    public TerminalStarter getTerminalStarter() {
        return this.terminalStarter;
    }

    class EmulatorTask
    implements Runnable {
        EmulatorTask() {
        }

        @Override
        public void run() {
            try {
                JediTermWidget.this.sessionRunning.set(true);
                Thread.currentThread().setName("Connector-" + JediTermWidget.this.ttyConnector.getName());
                if (JediTermWidget.this.ttyConnector.init()) {
                    JediTermWidget.this.terminalStarter.start();
                }
            }
            catch (Exception e) {
                log.error("Exception running terminal", (Throwable)e);
            }
            finally {
                try {
                    JediTermWidget.this.ttyConnector.close();
                }
                catch (Exception exception) {}
                JediTermWidget.this.sessionRunning.set(false);
            }
        }
    }
}

