/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.standard.ValueProvider;

public class FileValueProvider
implements ValueProvider {
    @Override
    public List<CompletionProposal> complete(CompletionContext completionContext) {
        String input = completionContext.currentWordUpToCursor();
        int lastSlash = input.lastIndexOf(File.separatorChar);
        Path dir = lastSlash > -1 ? Paths.get(input.substring(0, lastSlash + 1), new String[0]) : Paths.get("", new String[0]);
        String prefix = input.substring(lastSlash + 1);
        try {
            return Files.find(dir, 1, (p, a) -> p.getFileName() != null && p.getFileName().toString().startsWith(prefix), FileVisitOption.FOLLOW_LINKS).map(p -> {
                boolean directory = Files.isDirectory(p, new LinkOption[0]);
                String value = p.toString() + String.valueOf(directory ? Character.valueOf(File.separatorChar) : "");
                return new CompletionProposal(value).complete(!directory);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

