/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.support.search;

import org.springframework.shell.jline.tui.support.search.AbstractSearchMatchAlgorithm;
import org.springframework.shell.jline.tui.support.search.ExactMatchNaiveSearchMatchAlgorithm;
import org.springframework.shell.jline.tui.support.search.FuzzyMatchV2SearchMatchAlgorithm;
import org.springframework.shell.jline.tui.support.search.Normalize;
import org.springframework.shell.jline.tui.support.search.SearchMatchResult;

@FunctionalInterface
public interface SearchMatch {
    public SearchMatchResult match(String var1, String var2);

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static class DefaultBuilder
    implements Builder {
        private boolean caseSensitive;
        private boolean normalize;
        private boolean forward;

        @Override
        public Builder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public Builder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        @Override
        public Builder forward(boolean forward) {
            this.forward = forward;
            return this;
        }

        @Override
        public SearchMatch build() {
            return new DefaultSearchMatch(this.caseSensitive, this.normalize, this.forward);
        }
    }

    public static class DefaultSearchMatch
    implements SearchMatch {
        private boolean caseSensitive;
        private boolean normalize;
        private boolean forward;

        DefaultSearchMatch(boolean caseSensitive, boolean normalize, boolean forward) {
            this.caseSensitive = caseSensitive;
            this.normalize = normalize;
            this.forward = forward;
        }

        @Override
        public SearchMatchResult match(String text, String pattern) {
            AbstractSearchMatchAlgorithm algo = null;
            if (pattern != null) {
                if (!this.caseSensitive) {
                    pattern = pattern.toLowerCase();
                }
                if (this.normalize) {
                    pattern = Normalize.normalizeRunes(pattern);
                }
                if (pattern.startsWith("'")) {
                    algo = new ExactMatchNaiveSearchMatchAlgorithm();
                    pattern = pattern.substring(1);
                }
            }
            if (algo == null) {
                algo = new FuzzyMatchV2SearchMatchAlgorithm();
            }
            return algo.match(this.caseSensitive, this.normalize, this.forward, text, pattern);
        }
    }

    public static interface Builder {
        public Builder caseSensitive(boolean var1);

        public Builder normalize(boolean var1);

        public Builder forward(boolean var1);

        public SearchMatch build();
    }
}

