/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.style;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.utils.AttributedString;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.style.FigureSettings;
import org.springframework.shell.jline.tui.style.PartsText;
import org.springframework.shell.jline.tui.style.PartsTextRenderer;
import org.springframework.shell.jline.tui.style.StringToStyleExpressionRenderer;
import org.springframework.shell.jline.tui.style.ThemeResolver;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupString;
import org.stringtemplate.v4.misc.STMessage;

public class TemplateExecutor {
    private static final Log log = LogFactory.getLog(TemplateExecutor.class);
    private static final STErrorListener ERROR_LISTENER = new LoggingSTErrorListener();
    private final ThemeResolver themeResolver;
    private StringToStyleExpressionRenderer renderer1;
    private PartsTextRenderer renderer2;

    public TemplateExecutor(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
        this.renderer1 = new StringToStyleExpressionRenderer(themeResolver);
        this.renderer2 = new PartsTextRenderer(themeResolver);
    }

    public AttributedString render(String template, Map<String, @Nullable Object> attributes) {
        STGroup group = new STGroup();
        group.setListener(ERROR_LISTENER);
        group.registerRenderer(String.class, (AttributeRenderer)this.renderer1);
        group.registerRenderer(PartsText.class, (AttributeRenderer)this.renderer2);
        ST st = new ST(group, template);
        if (attributes != null) {
            attributes.entrySet().stream().forEach(e -> st.add((String)e.getKey(), e.getValue()));
        }
        String templateRendered = st.render();
        return this.themeResolver.evaluateExpression(templateRendered);
    }

    public AttributedString renderGroup(String template, Map<String, @Nullable Object> attributes) {
        STGroupString group = new STGroupString(template);
        group.setListener(ERROR_LISTENER);
        group.registerRenderer(String.class, (AttributeRenderer)this.renderer1);
        group.registerRenderer(PartsText.class, (AttributeRenderer)this.renderer2);
        Map<String, Object> figureDict = Stream.of(FigureSettings.tags()).collect(Collectors.toMap(tag -> tag, tag -> this.themeResolver.resolveFigureTag((String)tag)));
        group.defineDictionary("figures", figureDict);
        ST st = group.getInstanceOf("main");
        if (st == null) {
            throw new IllegalArgumentException("template instance 'main' not found from a group");
        }
        if (attributes != null) {
            attributes.entrySet().stream().forEach(e -> st.add((String)e.getKey(), e.getValue()));
        }
        String templateRendered = st.render();
        log.debug((Object)("Rendered template " + templateRendered));
        return this.themeResolver.evaluateExpression(templateRendered);
    }

    private static class LoggingSTErrorListener
    implements STErrorListener {
        private static final Log log = LogFactory.getLog(LoggingSTErrorListener.class);

        private LoggingSTErrorListener() {
        }

        public void compileTimeError(STMessage msg) {
            log.debug((Object)("compileTimeError [" + String.valueOf(msg) + "]"));
        }

        public void runTimeError(STMessage msg) {
            log.debug((Object)("runTimeError [" + String.valueOf(msg) + "]"));
        }

        public void IOError(STMessage msg) {
            log.debug((Object)("IOError [" + String.valueOf(msg) + "]"));
        }

        public void internalError(STMessage msg) {
            log.debug((Object)("internalError [" + String.valueOf(msg) + "]"));
        }
    }
}

