/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.shell.jline.tui.table.Aligner;
import org.springframework.shell.jline.tui.table.AutoSizeConstraints;
import org.springframework.shell.jline.tui.table.BorderSpecification;
import org.springframework.shell.jline.tui.table.BorderStyle;
import org.springframework.shell.jline.tui.table.CellMatcher;
import org.springframework.shell.jline.tui.table.CellMatchers;
import org.springframework.shell.jline.tui.table.DefaultFormatter;
import org.springframework.shell.jline.tui.table.DelimiterTextWrapper;
import org.springframework.shell.jline.tui.table.Formatter;
import org.springframework.shell.jline.tui.table.SimpleHorizontalAligner;
import org.springframework.shell.jline.tui.table.SizeConstraints;
import org.springframework.shell.jline.tui.table.Table;
import org.springframework.shell.jline.tui.table.TableModel;
import org.springframework.shell.jline.tui.table.TextWrapper;
import org.springframework.util.Assert;

public class TableBuilder {
    private final TableModel model;
    private final Map<CellMatcher, Formatter> formatters = new LinkedHashMap<CellMatcher, Formatter>();
    private final Map<CellMatcher, SizeConstraints> sizeConstraints = new LinkedHashMap<CellMatcher, SizeConstraints>();
    private final Map<CellMatcher, TextWrapper> wrappers = new LinkedHashMap<CellMatcher, TextWrapper>();
    private final LinkedHashMap<CellMatcher, Aligner> aligners = new LinkedHashMap();
    private final List<BorderSpecification> borderSpecifications = new ArrayList<BorderSpecification>();
    private final int rows;
    private final int columns;

    public TableBuilder(TableModel model) {
        this.model = model;
        this.rows = model.getRowCount();
        this.columns = model.getColumnCount();
        this.formatters.put(CellMatchers.table(), new DefaultFormatter());
        this.sizeConstraints.put(CellMatchers.table(), new AutoSizeConstraints());
        this.wrappers.put(CellMatchers.table(), new DelimiterTextWrapper());
        this.aligners.put(CellMatchers.table(), SimpleHorizontalAligner.left);
    }

    private TableBuilder addBorder(int top, int left, int bottom, int right, int match, BorderStyle style) {
        Assert.isTrue((top >= 0 && top < this.rows ? 1 : 0) != 0, (String)"top row must be positive and less than total number of rows");
        Assert.isTrue((left >= 0 && left < this.columns ? 1 : 0) != 0, (String)"left column must be positive and less than total number of columns");
        Assert.isTrue((bottom > top && bottom <= this.rows ? 1 : 0) != 0, (String)"bottom row must be greater than top and less than total number of rows");
        Assert.isTrue((right >= left && right <= this.columns ? 1 : 0) != 0, (String)"right column must be greater than left and less than total number of columns");
        Assert.notNull((Object)((Object)style), (String)"style cannot be null");
        this.borderSpecifications.add(new BorderSpecification(top, left, bottom, right, match, style));
        return this;
    }

    public TableModel getModel() {
        return this.model;
    }

    public CellMatcherStub on(CellMatcher matcher) {
        return new CellMatcherStub(matcher);
    }

    public Table build() {
        return new Table(this.model, this.reverse(this.formatters), this.reverse(this.sizeConstraints), this.reverse(this.wrappers), this.aligners, this.borderSpecifications);
    }

    public BorderStub paintBorder(BorderStyle style, int match) {
        return new BorderStub(style, match);
    }

    public TableBuilder addOutlineBorder(BorderStyle style) {
        this.addBorder(0, 0, this.model.getRowCount(), this.model.getColumnCount(), 15, style);
        return this;
    }

    public TableBuilder addHeaderBorder(BorderStyle style) {
        this.addBorder(0, 0, 1, this.model.getColumnCount(), 15, style);
        return this.addOutlineBorder(style);
    }

    public TableBuilder addFullBorder(BorderStyle style) {
        this.addBorder(0, 0, this.model.getRowCount(), this.model.getColumnCount(), 63, style);
        return this;
    }

    public TableBuilder addHeaderAndVerticalsBorders(BorderStyle style) {
        this.addBorder(0, 0, 1, this.model.getColumnCount(), 15, style);
        this.addBorder(0, 0, this.model.getRowCount(), this.model.getColumnCount(), 31, style);
        return this;
    }

    public TableBuilder addInnerBorder(BorderStyle style) {
        this.addBorder(0, 0, this.model.getRowCount(), this.model.getColumnCount(), 48, style);
        return this;
    }

    private <K, V> LinkedHashMap<K, V> reverse(Map<K, V> original) {
        LinkedHashMap result = new LinkedHashMap(original.size());
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(original.entrySet());
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public class CellMatcherStub {
        private final CellMatcher cellMatcher;

        private CellMatcherStub(CellMatcher cellMatcher) {
            this.cellMatcher = cellMatcher;
        }

        public CellMatcherStub addFormatter(Formatter formatter) {
            TableBuilder.this.formatters.put(this.cellMatcher, formatter);
            return this;
        }

        public CellMatcherStub addSizer(SizeConstraints sizer) {
            TableBuilder.this.sizeConstraints.put(this.cellMatcher, sizer);
            return this;
        }

        public CellMatcherStub addWrapper(TextWrapper textWrapper) {
            TableBuilder.this.wrappers.put(this.cellMatcher, textWrapper);
            return this;
        }

        public CellMatcherStub addAligner(Aligner aligner) {
            TableBuilder.this.aligners.put(this.cellMatcher, aligner);
            return this;
        }

        public CellMatcherStub on(CellMatcher other) {
            return TableBuilder.this.on(other);
        }

        public TableBuilder and() {
            return TableBuilder.this;
        }

        public Table build() {
            return TableBuilder.this.build();
        }
    }

    public class BorderStub {
        private final BorderStyle style;
        private final int match;

        private BorderStub(BorderStyle style, int match) {
            this.style = style;
            this.match = match;
        }

        public TopLeft fromRowColumn(int row, int column) {
            return new TopLeft(row, column);
        }

        public TopLeft fromTopLeft() {
            return new TopLeft(0, 0);
        }

        public class TopLeft {
            private final int row;
            private final int column;

            private TopLeft(int row, int column) {
                this.row = row;
                this.column = column;
            }

            public TableBuilder toRowColumn(int row, int column) {
                TableBuilder.this.addBorder(this.row, this.column, row, column, BorderStub.this.match, BorderStub.this.style);
                return TableBuilder.this;
            }

            public TableBuilder toBottomRight() {
                return this.toRowColumn(TableBuilder.this.model.getRowCount(), TableBuilder.this.model.getColumnCount());
            }
        }
    }
}

