/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.style;

import org.springframework.shell.jline.tui.style.FigureSettings;
import org.springframework.shell.jline.tui.style.SpinnerSettings;
import org.springframework.shell.jline.tui.style.StyleSettings;

public abstract class ThemeSettings {
    private StyleSettings styleSettings;
    private FigureSettings figureSettings;
    private SpinnerSettings spinnerSettings;

    public ThemeSettings() {
        this(StyleSettings.dump(), FigureSettings.dump());
    }

    public ThemeSettings(StyleSettings styleSettings) {
        this(styleSettings, FigureSettings.dump(), SpinnerSettings.dump());
    }

    public ThemeSettings(StyleSettings styleSettings, FigureSettings figureSettings) {
        this(styleSettings, figureSettings, SpinnerSettings.dump());
    }

    public ThemeSettings(StyleSettings styleSettings, FigureSettings figureSettings, SpinnerSettings spinnerSettings) {
        this.styleSettings = styleSettings;
        this.figureSettings = figureSettings;
        this.spinnerSettings = spinnerSettings;
    }

    public StyleSettings styles() {
        return this.styleSettings;
    }

    public FigureSettings figures() {
        return this.figureSettings;
    }

    public SpinnerSettings spinners() {
        return this.spinnerSettings;
    }

    public static ThemeSettings defaults() {
        return new DefaultThemeSettings(StyleSettings.defaults(), FigureSettings.defaults(), SpinnerSettings.defaults());
    }

    public static ThemeSettings dump() {
        return new DefaultThemeSettings();
    }

    private static class DefaultThemeSettings
    extends ThemeSettings {
        DefaultThemeSettings() {
        }

        DefaultThemeSettings(StyleSettings styleSettings, FigureSettings figureSettings, SpinnerSettings spinnerSettings) {
            super(styleSettings, figureSettings, spinnerSettings);
        }
    }
}

