/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.support;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.support.Nameable;
import org.springframework.shell.jline.tui.component.support.Selectable;

public interface SelectorList<T extends Nameable> {
    public void reset(List<T> var1);

    public @Nullable T getSelected();

    public void scrollUp();

    public void scrollDown();

    public List<ProjectionItem<T>> getProjection();

    public static <T extends Nameable> SelectorList<T> of(int max) {
        return new DefaultSelectorList(max);
    }

    public static class DefaultSelectorList<T extends Nameable>
    implements SelectorList<T> {
        private final List<T> items = new ArrayList<T>();
        private final int max;
        private int start;
        private int position;

        public DefaultSelectorList(int max) {
            this.max = max;
        }

        @Override
        public void reset(List<T> items) {
            this.items.clear();
            this.items.addAll(items);
            this.start = 0;
            this.position = 0;
        }

        @Override
        public @Nullable T getSelected() {
            int index = this.start + this.position;
            if (this.items.isEmpty()) {
                return null;
            }
            return (T)((Nameable)this.items.get(index));
        }

        @Override
        public void scrollUp() {
            if (this.start > 0 && this.position == 0) {
                --this.start;
            } else if (this.start + this.position <= 0) {
                if (this.items.size() < this.max) {
                    this.start = 0;
                    this.position = this.items.size() - 1;
                } else {
                    this.start = this.items.size() - this.max;
                    this.position = this.max - 1;
                }
            } else {
                --this.position;
            }
        }

        @Override
        public void scrollDown() {
            if (this.start + this.position + 1 < Math.min(this.items.size(), this.max)) {
                ++this.position;
            } else if (this.start + this.position + 1 >= this.items.size()) {
                this.start = 0;
                this.position = 0;
            } else if (this.position < this.max - 1) {
                ++this.position;
            } else {
                ++this.start;
            }
        }

        @Override
        public List<ProjectionItem<T>> getProjection() {
            ArrayList<ProjectionItem<T>> projection = new ArrayList<ProjectionItem<T>>();
            for (int i = this.start; i < this.start + Math.min(this.items.size(), this.max); ++i) {
                boolean selected = i == this.start + this.position;
                BaseProjectionItem<Nameable> item = new BaseProjectionItem<Nameable>((Nameable)this.items.get(i), selected);
                projection.add(item);
            }
            return projection;
        }
    }

    public static class BaseProjectionItem<T extends Nameable>
    implements ProjectionItem<T> {
        private final T item;
        private final boolean selected;

        BaseProjectionItem(T item, boolean selected) {
            this.item = item;
            this.selected = selected;
        }

        @Override
        public T getItem() {
            return this.item;
        }

        @Override
        public String getName() {
            return this.item.getName();
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }
    }

    public static interface ProjectionItem<T>
    extends Nameable,
    Selectable {
        public T getItem();
    }
}

