/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jline.reader.History;
import org.springframework.shell.core.command.annotation.Command;
import org.springframework.shell.core.command.annotation.Option;

public class History {
    private final org.jline.reader.History jLineHistory;

    public History(org.jline.reader.History jLineHistory) {
        this.jLineHistory = jLineHistory;
    }

    @Command(name={"history"}, description="Display or save the history of previously run commands")
    public List<String> history(@Option(description="A file to save history to.") File file) throws IOException {
        if (file == null) {
            ArrayList<String> result = new ArrayList<String>(this.jLineHistory.size());
            this.jLineHistory.forEach(e -> result.add(e.line()));
            return result;
        }
        try (FileWriter w = new FileWriter(file);){
            for (History.Entry entry : this.jLineHistory) {
                w.append(entry.line()).append(System.lineSeparator());
            }
        }
        return Collections.singletonList(String.format("Wrote %d entries to %s", this.jLineHistory.size(), file));
    }
}

