/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.springframework.shell.jline.tui.component.ViewComponentExecutor;
import org.springframework.shell.jline.tui.component.message.ShellMessageBuilder;
import org.springframework.shell.jline.tui.component.view.TerminalUI;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.control.ViewDoneEvent;
import org.springframework.shell.jline.tui.component.view.event.EventLoop;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.util.Assert;

public class ViewComponent {
    private static final Log log = LogFactory.getLog(ViewComponent.class);
    private final Terminal terminal;
    private final View view;
    private EventLoop eventLoop;
    private TerminalUI terminalUI;
    private boolean useTerminalWidth = true;
    private ViewComponentExecutor viewComponentExecutor;

    public ViewComponent(TerminalUI terminalUI, Terminal terminal, ViewComponentExecutor viewComponentExecutor, View view) {
        Assert.notNull((Object)terminalUI, (String)"terminal ui must be set");
        Assert.notNull((Object)terminal, (String)"terminal must be set");
        Assert.notNull((Object)view, (String)"view must be set");
        this.terminalUI = terminalUI;
        this.terminal = terminal;
        this.view = view;
        this.viewComponentExecutor = viewComponentExecutor;
        this.eventLoop = terminalUI.getEventLoop();
        view.setEventLoop(this.eventLoop);
    }

    public ViewComponentRun runAsync() {
        ViewComponentRun run = this.viewComponentExecutor.start(() -> this.runBlocking());
        return run;
    }

    public void runBlocking() {
        log.debug((Object)"Start run()");
        this.eventLoop.onDestroy(this.eventLoop.viewEvents(ViewDoneEvent.class, this.view).subscribe(event -> this.exit()));
        this.view.setEventLoop(this.eventLoop);
        Size terminalSize = this.terminal.getSize();
        Rectangle rect = this.view.getRect();
        if (this.useTerminalWidth) {
            this.view.setRect(rect.x(), rect.y(), terminalSize.getColumns() - rect.x(), rect.height());
        }
        this.terminalUI.setRoot(this.view, false);
        this.terminalUI.run();
        log.debug((Object)"End run()");
    }

    public void setUseTerminalWidth(boolean useTerminalWidth) {
        this.useTerminalWidth = useTerminalWidth;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public void exit() {
        this.eventLoop.dispatch(ShellMessageBuilder.ofInterrupt());
    }

    public static interface ViewComponentRun {
        public void await();

        public void cancel();

        public boolean isDone();
    }
}

