/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.jline.tui.style.TemplateExecutor;
import org.springframework.shell.jline.tui.style.Theme;
import org.springframework.shell.jline.tui.style.ThemeActive;
import org.springframework.shell.jline.tui.style.ThemeRegistry;
import org.springframework.shell.jline.tui.style.ThemeResolver;
import org.springframework.shell.jline.tui.style.ThemeSettings;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class ThemingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ThemeActive themeActive() {
        return () -> {
            if (System.getenv("CI") != null || System.getenv("NO_COLOR") != null) {
                return "dump";
            }
            return "default";
        };
    }

    @Bean
    public ThemeRegistry themeRegistry(ObjectProvider<Theme> themes) {
        ThemeRegistry registry = new ThemeRegistry();
        registry.register(Theme.of((String)"default", (ThemeSettings)ThemeSettings.defaults()));
        registry.register(Theme.of((String)"dump", (ThemeSettings)ThemeSettings.dump()));
        themes.orderedStream().forEachOrdered(arg_0 -> ((ThemeRegistry)registry).register(arg_0));
        return registry;
    }

    @Bean
    public ThemeResolver shellThemeResolver(ThemeRegistry themeRegistry, SpringShellProperties properties, ThemeActive themeActive) {
        String themeName = properties.getTheme().getName();
        if (!StringUtils.hasText((String)themeName)) {
            themeName = (String)themeActive.get();
        }
        if (!StringUtils.hasText((String)themeName)) {
            themeName = "default";
        }
        return new ThemeResolver(themeRegistry, themeName);
    }

    @Bean
    public TemplateExecutor templateExecutor(ThemeResolver themeResolver) {
        return new TemplateExecutor(themeResolver);
    }
}

