/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.boot.ExitCodeExceptionMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.shell.command.CommandExecution;
import org.springframework.shell.exit.ExitCodeMappings;

@Configuration(proxyBeanMethods=false)
public class ExitCodeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ShellExitCodeExceptionMapper shellExitCodeExceptionMapper() {
        return new ShellExitCodeExceptionMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public ShellExitCodeMappingsExceptionMapper shellExitCodeMappingsExceptionMapper() {
        return new ShellExitCodeMappingsExceptionMapper();
    }

    static class ShellExitCodeMappingsExceptionMapper
    implements ExitCodeExceptionMapper,
    ExitCodeMappings {
        private final List<Function<Throwable, Integer>> functions = new ArrayList<Function<Throwable, Integer>>();

        ShellExitCodeMappingsExceptionMapper() {
        }

        public void reset(List<Function<Throwable, Integer>> functions) {
            this.functions.clear();
            if (functions != null) {
                this.functions.addAll(functions);
            }
        }

        public int getExitCode(Throwable exception) {
            int exitCode = 0;
            for (Function<Throwable, Integer> function : this.functions) {
                Integer code = function.apply(exception.getCause());
                if (code == null || (code <= 0 || code <= exitCode) && (code >= 0 || code >= exitCode)) continue;
                exitCode = code;
            }
            return exitCode;
        }
    }

    static class ShellExitCodeExceptionMapper
    implements ExitCodeExceptionMapper {
        ShellExitCodeExceptionMapper() {
        }

        public int getExitCode(Throwable exception) {
            if (exception.getCause() instanceof CommandExecution.CommandParserExceptionsException) {
                return 2;
            }
            return 0;
        }
    }
}

