/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.context.ApplicationListener;
import org.springframework.session.ExpiringSession;
import org.springframework.session.events.AbstractSessionEvent;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.web.http.ExpiringSessionHttpSession;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEventHttpSessionListenerAdapter
implements ApplicationListener<AbstractSessionEvent>,
ServletContextAware {
    private final List<HttpSessionListener> listeners;
    private ServletContext context;

    public SessionEventHttpSessionListenerAdapter(List<HttpSessionListener> listeners) {
        this.listeners = listeners;
    }

    public void onApplicationEvent(AbstractSessionEvent event) {
        if (this.listeners.isEmpty()) {
            return;
        }
        HttpSessionEvent httpSessionEvent = this.createHttpSessionEvent(event);
        for (HttpSessionListener listener : this.listeners) {
            if (event instanceof SessionDestroyedEvent) {
                listener.sessionDestroyed(httpSessionEvent);
                continue;
            }
            if (!(event instanceof SessionCreatedEvent)) continue;
            listener.sessionCreated(httpSessionEvent);
        }
    }

    private HttpSessionEvent createHttpSessionEvent(AbstractSessionEvent event) {
        ExpiringSession session = (ExpiringSession)event.getSession();
        ExpiringSessionHttpSession<ExpiringSession> httpSession = new ExpiringSessionHttpSession<ExpiringSession>(session, this.context);
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent(httpSession);
        return httpSessionEvent;
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }
}

