/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.dao.DataAccessException;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcOperationsSessionRepository
implements FindByIndexNameSessionRepository<JdbcSession> {
    public static final String DEFAULT_TABLE_NAME = "SPRING_SESSION";
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final String CREATE_SESSION_QUERY = "INSERT INTO %TABLE_NAME%(PRIMARY_ID, SESSION_ID, CREATION_TIME, LAST_ACCESS_TIME, MAX_INACTIVE_INTERVAL, EXPIRY_TIME, PRINCIPAL_NAME) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO %TABLE_NAME%_ATTRIBUTES(SESSION_PRIMARY_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?)";
    private static final String GET_SESSION_QUERY = "SELECT S.PRIMARY_ID, S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM %TABLE_NAME% S LEFT OUTER JOIN %TABLE_NAME%_ATTRIBUTES SA ON S.PRIMARY_ID = SA.SESSION_PRIMARY_ID WHERE S.SESSION_ID = ?";
    private static final String UPDATE_SESSION_QUERY = "UPDATE %TABLE_NAME% SET SESSION_ID = ?, LAST_ACCESS_TIME = ?, MAX_INACTIVE_INTERVAL = ?, EXPIRY_TIME = ?, PRINCIPAL_NAME = ? WHERE PRIMARY_ID = ?";
    private static final String UPDATE_SESSION_ATTRIBUTE_QUERY = "UPDATE %TABLE_NAME%_ATTRIBUTES SET ATTRIBUTE_BYTES = ? WHERE SESSION_PRIMARY_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_ATTRIBUTE_QUERY = "DELETE FROM %TABLE_NAME%_ATTRIBUTES WHERE SESSION_PRIMARY_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_QUERY = "DELETE FROM %TABLE_NAME% WHERE SESSION_ID = ?";
    private static final String LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT S.PRIMARY_ID, S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM %TABLE_NAME% S LEFT OUTER JOIN %TABLE_NAME%_ATTRIBUTES SA ON S.PRIMARY_ID = SA.SESSION_PRIMARY_ID WHERE S.PRINCIPAL_NAME = ?";
    private static final String DELETE_SESSIONS_BY_EXPIRY_TIME_QUERY = "DELETE FROM %TABLE_NAME% WHERE EXPIRY_TIME < ?";
    private static final Log logger = LogFactory.getLog(JdbcOperationsSessionRepository.class);
    private static final PrincipalNameResolver PRINCIPAL_NAME_RESOLVER = new PrincipalNameResolver();
    private final JdbcOperations jdbcOperations;
    private final TransactionOperations transactionOperations;
    private final ResultSetExtractor<List<JdbcSession>> extractor = new SessionResultSetExtractor();
    private String tableName = "SPRING_SESSION";
    private String createSessionQuery;
    private String createSessionAttributeQuery;
    private String getSessionQuery;
    private String updateSessionQuery;
    private String updateSessionAttributeQuery;
    private String deleteSessionAttributeQuery;
    private String deleteSessionQuery;
    private String listSessionsByPrincipalNameQuery;
    private String deleteSessionsByExpiryTimeQuery;
    private Integer defaultMaxInactiveInterval;
    private ConversionService conversionService;
    private LobHandler lobHandler = new DefaultLobHandler();

    public JdbcOperationsSessionRepository(JdbcOperations jdbcOperations, PlatformTransactionManager transactionManager) {
        Assert.notNull((Object)jdbcOperations, (String)"JdbcOperations must not be null");
        this.jdbcOperations = jdbcOperations;
        this.transactionOperations = JdbcOperationsSessionRepository.createTransactionTemplate(transactionManager);
        this.conversionService = JdbcOperationsSessionRepository.createDefaultConversionService();
        this.prepareQueries();
    }

    public void setTableName(String tableName) {
        Assert.hasText((String)tableName, (String)"Table name must not be empty");
        this.tableName = tableName.trim();
        this.prepareQueries();
    }

    public void setCreateSessionQuery(String createSessionQuery) {
        Assert.hasText((String)createSessionQuery, (String)"Query must not be empty");
        this.createSessionQuery = createSessionQuery;
    }

    public void setCreateSessionAttributeQuery(String createSessionAttributeQuery) {
        Assert.hasText((String)createSessionAttributeQuery, (String)"Query must not be empty");
        this.createSessionAttributeQuery = createSessionAttributeQuery;
    }

    public void setGetSessionQuery(String getSessionQuery) {
        Assert.hasText((String)getSessionQuery, (String)"Query must not be empty");
        this.getSessionQuery = getSessionQuery;
    }

    public void setUpdateSessionQuery(String updateSessionQuery) {
        Assert.hasText((String)updateSessionQuery, (String)"Query must not be empty");
        this.updateSessionQuery = updateSessionQuery;
    }

    public void setUpdateSessionAttributeQuery(String updateSessionAttributeQuery) {
        Assert.hasText((String)updateSessionAttributeQuery, (String)"Query must not be empty");
        this.updateSessionAttributeQuery = updateSessionAttributeQuery;
    }

    public void setDeleteSessionAttributeQuery(String deleteSessionAttributeQuery) {
        Assert.hasText((String)deleteSessionAttributeQuery, (String)"Query must not be empty");
        this.deleteSessionAttributeQuery = deleteSessionAttributeQuery;
    }

    public void setDeleteSessionQuery(String deleteSessionQuery) {
        Assert.hasText((String)deleteSessionQuery, (String)"Query must not be empty");
        this.deleteSessionQuery = deleteSessionQuery;
    }

    public void setListSessionsByPrincipalNameQuery(String listSessionsByPrincipalNameQuery) {
        Assert.hasText((String)listSessionsByPrincipalNameQuery, (String)"Query must not be empty");
        this.listSessionsByPrincipalNameQuery = listSessionsByPrincipalNameQuery;
    }

    public void setDeleteSessionsByExpiryTimeQuery(String deleteSessionsByExpiryTimeQuery) {
        Assert.hasText((String)deleteSessionsByExpiryTimeQuery, (String)"Query must not be empty");
        this.deleteSessionsByExpiryTimeQuery = deleteSessionsByExpiryTimeQuery;
    }

    public void setDefaultMaxInactiveInterval(Integer defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setLobHandler(LobHandler lobHandler) {
        Assert.notNull((Object)lobHandler, (String)"LobHandler must not be null");
        this.lobHandler = lobHandler;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    public JdbcSession createSession() {
        JdbcSession session = new JdbcSession();
        if (this.defaultMaxInactiveInterval != null) {
            session.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
        }
        return session;
    }

    public void save(final JdbcSession session) {
        if (session.isNew()) {
            this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.createSessionQuery, ps -> {
                        ps.setString(1, session.primaryKey);
                        ps.setString(2, session.getId());
                        ps.setLong(3, session.getCreationTime().toEpochMilli());
                        ps.setLong(4, session.getLastAccessedTime().toEpochMilli());
                        ps.setInt(5, (int)session.getMaxInactiveInterval().getSeconds());
                        ps.setLong(6, session.getExpiryTime().toEpochMilli());
                        ps.setString(7, session.getPrincipalName());
                    });
                    if (!session.getAttributeNames().isEmpty()) {
                        ArrayList<String> attributeNames = new ArrayList<String>(session.getAttributeNames());
                        JdbcOperationsSessionRepository.this.insertSessionAttributes(session, attributeNames);
                    }
                }
            });
        } else {
            this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    if (session.isChanged()) {
                        JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.updateSessionQuery, ps -> {
                            ps.setString(1, session.getId());
                            ps.setLong(2, session.getLastAccessedTime().toEpochMilli());
                            ps.setInt(3, (int)session.getMaxInactiveInterval().getSeconds());
                            ps.setLong(4, session.getExpiryTime().toEpochMilli());
                            ps.setString(5, session.getPrincipalName());
                            ps.setString(6, session.primaryKey);
                        });
                    }
                    List addedAttributeNames = session.delta.entrySet().stream().filter(entry -> entry.getValue() == DeltaValue.ADDED).map(Map.Entry::getKey).collect(Collectors.toList());
                    JdbcOperationsSessionRepository.this.insertSessionAttributes(session, addedAttributeNames);
                    List updatedAttributeNames = session.delta.entrySet().stream().filter(entry -> entry.getValue() == DeltaValue.UPDATED).map(Map.Entry::getKey).collect(Collectors.toList());
                    JdbcOperationsSessionRepository.this.updateSessionAttributes(session, updatedAttributeNames);
                    List removedAttributeNames = session.delta.entrySet().stream().filter(entry -> entry.getValue() == DeltaValue.REMOVED).map(Map.Entry::getKey).collect(Collectors.toList());
                    JdbcOperationsSessionRepository.this.deleteSessionAttributes(session, removedAttributeNames);
                }
            });
        }
        session.clearChangeFlags();
    }

    public JdbcSession findById(String id) {
        JdbcSession session = (JdbcSession)this.transactionOperations.execute(status -> {
            List sessions = (List)this.jdbcOperations.query(this.getSessionQuery, ps -> ps.setString(1, id), this.extractor);
            if (sessions.isEmpty()) {
                return null;
            }
            return (JdbcSession)sessions.get(0);
        });
        if (session != null) {
            if (session.isExpired()) {
                this.deleteById(id);
            } else {
                return session;
            }
        }
        return null;
    }

    public void deleteById(final String id) {
        this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.deleteSessionQuery, new Object[]{id});
            }
        });
    }

    public Map<String, JdbcSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        List sessions = (List)this.transactionOperations.execute(status -> (List)this.jdbcOperations.query(this.listSessionsByPrincipalNameQuery, ps -> ps.setString(1, indexValue), this.extractor));
        HashMap<String, JdbcSession> sessionMap = new HashMap<String, JdbcSession>(sessions.size());
        for (JdbcSession session : sessions) {
            sessionMap.put(session.getId(), session);
        }
        return sessionMap;
    }

    private void insertSessionAttributes(final JdbcSession session, final List<String> attributeNames) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            return;
        }
        if (attributeNames.size() > 1) {
            this.jdbcOperations.batchUpdate(this.createSessionAttributeQuery, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    String attributeName = (String)attributeNames.get(i);
                    ps.setString(1, session.primaryKey);
                    ps.setString(2, attributeName);
                    JdbcOperationsSessionRepository.this.serialize(ps, 3, session.getAttribute(attributeName));
                }

                public int getBatchSize() {
                    return attributeNames.size();
                }
            });
        } else {
            this.jdbcOperations.update(this.createSessionAttributeQuery, ps -> {
                String attributeName = (String)attributeNames.get(0);
                ps.setString(1, session.primaryKey);
                ps.setString(2, attributeName);
                this.serialize(ps, 3, session.getAttribute(attributeName));
            });
        }
    }

    private void updateSessionAttributes(final JdbcSession session, final List<String> attributeNames) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            return;
        }
        if (attributeNames.size() > 1) {
            this.jdbcOperations.batchUpdate(this.updateSessionAttributeQuery, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    String attributeName = (String)attributeNames.get(i);
                    JdbcOperationsSessionRepository.this.serialize(ps, 1, session.getAttribute(attributeName));
                    ps.setString(2, session.primaryKey);
                    ps.setString(3, attributeName);
                }

                public int getBatchSize() {
                    return attributeNames.size();
                }
            });
        } else {
            this.jdbcOperations.update(this.updateSessionAttributeQuery, ps -> {
                String attributeName = (String)attributeNames.get(0);
                this.serialize(ps, 1, session.getAttribute(attributeName));
                ps.setString(2, session.primaryKey);
                ps.setString(3, attributeName);
            });
        }
    }

    private void deleteSessionAttributes(final JdbcSession session, final List<String> attributeNames) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            return;
        }
        if (attributeNames.size() > 1) {
            this.jdbcOperations.batchUpdate(this.deleteSessionAttributeQuery, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    String attributeName = (String)attributeNames.get(i);
                    ps.setString(1, session.primaryKey);
                    ps.setString(2, attributeName);
                }

                public int getBatchSize() {
                    return attributeNames.size();
                }
            });
        } else {
            this.jdbcOperations.update(this.deleteSessionAttributeQuery, ps -> {
                String attributeName = (String)attributeNames.get(0);
                ps.setString(1, session.primaryKey);
                ps.setString(2, attributeName);
            });
        }
    }

    public void cleanUpExpiredSessions() {
        Integer deletedCount = (Integer)this.transactionOperations.execute(transactionStatus -> this.jdbcOperations.update(this.deleteSessionsByExpiryTimeQuery, new Object[]{System.currentTimeMillis()}));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaned up " + deletedCount + " expired sessions"));
        }
    }

    private static TransactionTemplate createTransactionTemplate(PlatformTransactionManager transactionManager) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }

    private static GenericConversionService createDefaultConversionService() {
        GenericConversionService converter = new GenericConversionService();
        converter.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        converter.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter());
        return converter;
    }

    private String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%TABLE_NAME%", (String)this.tableName);
    }

    private void prepareQueries() {
        this.createSessionQuery = this.getQuery(CREATE_SESSION_QUERY);
        this.createSessionAttributeQuery = this.getQuery(CREATE_SESSION_ATTRIBUTE_QUERY);
        this.getSessionQuery = this.getQuery(GET_SESSION_QUERY);
        this.updateSessionQuery = this.getQuery(UPDATE_SESSION_QUERY);
        this.updateSessionAttributeQuery = this.getQuery(UPDATE_SESSION_ATTRIBUTE_QUERY);
        this.deleteSessionAttributeQuery = this.getQuery(DELETE_SESSION_ATTRIBUTE_QUERY);
        this.deleteSessionQuery = this.getQuery(DELETE_SESSION_QUERY);
        this.listSessionsByPrincipalNameQuery = this.getQuery(LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY);
        this.deleteSessionsByExpiryTimeQuery = this.getQuery(DELETE_SESSIONS_BY_EXPIRY_TIME_QUERY);
    }

    private void serialize(PreparedStatement ps, int paramIndex, Object attributeValue) throws SQLException {
        this.lobHandler.getLobCreator().setBlobAsBytes(ps, paramIndex, (byte[])this.conversionService.convert(attributeValue, TypeDescriptor.valueOf(Object.class), TypeDescriptor.valueOf(byte[].class)));
    }

    private Object deserialize(ResultSet rs, String columnName) throws SQLException {
        return this.conversionService.convert((Object)this.lobHandler.getBlobAsBytes(rs, columnName), TypeDescriptor.valueOf(byte[].class), TypeDescriptor.valueOf(Object.class));
    }

    private class SessionResultSetExtractor
    implements ResultSetExtractor<List<JdbcSession>> {
        private SessionResultSetExtractor() {
        }

        public List<JdbcSession> extractData(ResultSet rs) throws SQLException, DataAccessException {
            ArrayList<JdbcSession> sessions = new ArrayList<JdbcSession>();
            while (rs.next()) {
                JdbcSession session;
                String id = rs.getString("SESSION_ID");
                if (sessions.size() > 0 && this.getLast(sessions).getId().equals(id)) {
                    session = this.getLast(sessions);
                } else {
                    MapSession delegate = new MapSession(id);
                    String primaryKey = rs.getString("PRIMARY_ID");
                    delegate.setCreationTime(Instant.ofEpochMilli(rs.getLong("CREATION_TIME")));
                    delegate.setLastAccessedTime(Instant.ofEpochMilli(rs.getLong("LAST_ACCESS_TIME")));
                    delegate.setMaxInactiveInterval(Duration.ofSeconds(rs.getInt("MAX_INACTIVE_INTERVAL")));
                    session = new JdbcSession(primaryKey, (Session)delegate);
                }
                String attributeName = rs.getString("ATTRIBUTE_NAME");
                if (attributeName != null) {
                    session.delegate.setAttribute(attributeName, JdbcOperationsSessionRepository.this.deserialize(rs, "ATTRIBUTE_BYTES"));
                }
                sessions.add(session);
            }
            return sessions;
        }

        private JdbcSession getLast(List<JdbcSession> sessions) {
            return sessions.get(sessions.size() - 1);
        }
    }

    static class PrincipalNameResolver {
        private SpelExpressionParser parser = new SpelExpressionParser();

        PrincipalNameResolver() {
        }

        public String resolvePrincipal(Session session) {
            String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
            if (principalName != null) {
                return principalName;
            }
            Object authentication = session.getAttribute(JdbcOperationsSessionRepository.SPRING_SECURITY_CONTEXT);
            if (authentication != null) {
                Expression expression = this.parser.parseExpression("authentication?.name");
                return (String)expression.getValue(authentication, String.class);
            }
            return null;
        }
    }

    final class JdbcSession
    implements Session {
        private final Session delegate;
        private final String primaryKey;
        private boolean isNew;
        private boolean changed;
        private Map<String, DeltaValue> delta = new HashMap<String, DeltaValue>();

        JdbcSession() {
            this.delegate = new MapSession();
            this.isNew = true;
            this.primaryKey = UUID.randomUUID().toString();
        }

        JdbcSession(String primaryKey, Session delegate) {
            Assert.notNull((Object)primaryKey, (String)"primaryKey cannot be null");
            Assert.notNull((Object)delegate, (String)"Session cannot be null");
            this.primaryKey = primaryKey;
            this.delegate = delegate;
        }

        boolean isNew() {
            return this.isNew;
        }

        boolean isChanged() {
            return this.changed;
        }

        Map<String, DeltaValue> getDelta() {
            return this.delta;
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.changed = false;
            this.delta.clear();
        }

        String getPrincipalName() {
            return PRINCIPAL_NAME_RESOLVER.resolvePrincipal(this);
        }

        Instant getExpiryTime() {
            return this.getLastAccessedTime().plus(this.getMaxInactiveInterval());
        }

        public String getId() {
            return this.delegate.getId();
        }

        public String changeSessionId() {
            this.changed = true;
            return this.delegate.changeSessionId();
        }

        public <T> T getAttribute(String attributeName) {
            return (T)this.delegate.getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            if (attributeValue == null) {
                this.delta.put(attributeName, DeltaValue.REMOVED);
            } else if (this.delegate.getAttribute(attributeName) != null) {
                this.delta.put(attributeName, DeltaValue.UPDATED);
            } else {
                this.delta.put(attributeName, DeltaValue.ADDED);
            }
            this.delegate.setAttribute(attributeName, attributeValue);
            if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(attributeName) || JdbcOperationsSessionRepository.SPRING_SECURITY_CONTEXT.equals(attributeName)) {
                this.changed = true;
            }
        }

        public void removeAttribute(String attributeName) {
            this.setAttribute(attributeName, null);
        }

        public Instant getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.changed = true;
        }

        public Instant getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.delegate.setMaxInactiveInterval(interval);
            this.changed = true;
        }

        public Duration getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }
    }

    private static enum DeltaValue {
        ADDED,
        UPDATED,
        REMOVED;

    }
}

