/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryExpiredListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicates;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.DelegatingIndexResolver;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.PrincipalNameIndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.session.hazelcast.Hazelcast4SessionUpdateEntryProcessor;
import org.springframework.util.Assert;

public class Hazelcast4IndexedSessionRepository
implements FindByIndexNameSessionRepository<HazelcastSession>,
EntryAddedListener<String, MapSession>,
EntryEvictedListener<String, MapSession>,
EntryRemovedListener<String, MapSession>,
EntryExpiredListener<String, MapSession> {
    public static final String DEFAULT_SESSION_MAP_NAME = "spring:session:sessions";
    public static final String PRINCIPAL_NAME_ATTRIBUTE = "principalName";
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final Log logger = LogFactory.getLog(Hazelcast4IndexedSessionRepository.class);
    private final HazelcastInstance hazelcastInstance;
    private ApplicationEventPublisher eventPublisher = event -> {};
    private Integer defaultMaxInactiveInterval;
    private IndexResolver<Session> indexResolver = new DelegatingIndexResolver(new IndexResolver[]{new PrincipalNameIndexResolver()});
    private String sessionMapName = "spring:session:sessions";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private IMap<String, MapSession> sessions;
    private UUID sessionListenerId;

    public Hazelcast4IndexedSessionRepository(HazelcastInstance hazelcastInstance) {
        Assert.notNull((Object)hazelcastInstance, (String)"HazelcastInstance must not be null");
        this.hazelcastInstance = hazelcastInstance;
    }

    @PostConstruct
    public void init() {
        this.sessions = this.hazelcastInstance.getMap(this.sessionMapName);
        this.sessionListenerId = this.sessions.addEntryListener((MapListener)this, true);
    }

    @PreDestroy
    public void close() {
        this.sessions.removeEntryListener(this.sessionListenerId);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher cannot be null");
        this.eventPublisher = applicationEventPublisher;
    }

    public void setDefaultMaxInactiveInterval(Integer defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        Assert.notNull(indexResolver, (String)"indexResolver cannot be null");
        this.indexResolver = indexResolver;
    }

    public void setSessionMapName(String sessionMapName) {
        Assert.hasText((String)sessionMapName, (String)"Map name must not be empty");
        this.sessionMapName = sessionMapName;
    }

    public void setFlushMode(FlushMode flushMode) {
        Assert.notNull((Object)flushMode, (String)"flushMode cannot be null");
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    public HazelcastSession createSession() {
        MapSession cached = new MapSession();
        if (this.defaultMaxInactiveInterval != null) {
            cached.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
        }
        HazelcastSession session = new HazelcastSession(cached, true);
        session.flushImmediateIfNecessary();
        return session;
    }

    public void save(HazelcastSession session) {
        if (session.isNew) {
            this.sessions.set((Object)session.getId(), (Object)session.getDelegate(), session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
        } else if (session.sessionIdChanged) {
            this.sessions.delete((Object)session.originalId);
            session.originalId = session.getId();
            this.sessions.set((Object)session.getId(), (Object)session.getDelegate(), session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
        } else if (session.hasChanges()) {
            Hazelcast4SessionUpdateEntryProcessor entryProcessor = new Hazelcast4SessionUpdateEntryProcessor();
            if (session.lastAccessedTimeChanged) {
                entryProcessor.setLastAccessedTime(session.getLastAccessedTime());
            }
            if (session.maxInactiveIntervalChanged) {
                entryProcessor.setMaxInactiveInterval(session.getMaxInactiveInterval());
            }
            if (!session.delta.isEmpty()) {
                entryProcessor.setDelta(new HashMap<String, Object>(session.delta));
            }
            this.sessions.executeOnKey((Object)session.getId(), (EntryProcessor)entryProcessor);
        }
        session.clearChangeFlags();
    }

    public HazelcastSession findById(String id) {
        MapSession saved = (MapSession)this.sessions.get((Object)id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.deleteById(saved.getId());
            return null;
        }
        return new HazelcastSession(saved, false);
    }

    public void deleteById(String id) {
        this.sessions.remove((Object)id);
    }

    public Map<String, HazelcastSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        Collection sessions = this.sessions.values(Predicates.equal((String)PRINCIPAL_NAME_ATTRIBUTE, (Comparable)((Object)indexValue)));
        HashMap<String, HazelcastSession> sessionMap = new HashMap<String, HazelcastSession>(sessions.size());
        for (MapSession session : sessions) {
            sessionMap.put(session.getId(), new HazelcastSession(session, false));
        }
        return sessionMap;
    }

    public void entryAdded(EntryEvent<String, MapSession> event) {
        MapSession session = (MapSession)event.getValue();
        if (session.getId().equals(session.getOriginalId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Session created with id: " + session.getId()));
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)session));
        }
    }

    public void entryEvicted(EntryEvent<String, MapSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session expired with id: " + ((MapSession)event.getOldValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)event.getOldValue()));
    }

    public void entryRemoved(EntryEvent<String, MapSession> event) {
        MapSession session = (MapSession)event.getOldValue();
        if (session != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Session deleted with id: " + session.getId()));
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)session));
        }
    }

    public void entryExpired(EntryEvent<String, MapSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session expired with id: " + ((MapSession)event.getOldValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)event.getOldValue()));
    }

    final class HazelcastSession
    implements Session {
        private final MapSession delegate;
        private boolean isNew;
        private boolean sessionIdChanged;
        private boolean lastAccessedTimeChanged;
        private boolean maxInactiveIntervalChanged;
        private String originalId;
        private Map<String, Object> delta = new HashMap<String, Object>();

        HazelcastSession(MapSession cached, boolean isNew) {
            this.delegate = cached;
            this.isNew = isNew;
            this.originalId = cached.getId();
            if (this.isNew || Hazelcast4IndexedSessionRepository.this.saveMode == SaveMode.ALWAYS) {
                this.getAttributeNames().forEach(attributeName -> this.delta.put((String)attributeName, cached.getAttribute(attributeName)));
            }
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.lastAccessedTimeChanged = true;
            this.flushImmediateIfNecessary();
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }

        public Instant getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public String getId() {
            return this.delegate.getId();
        }

        public String changeSessionId() {
            String newSessionId = this.delegate.changeSessionId();
            this.sessionIdChanged = true;
            return newSessionId;
        }

        public Instant getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            Assert.notNull((Object)interval, (String)"interval must not be null");
            this.delegate.setMaxInactiveInterval(interval);
            this.maxInactiveIntervalChanged = true;
            this.flushImmediateIfNecessary();
        }

        public Duration getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public <T> T getAttribute(String attributeName) {
            Object attributeValue = this.delegate.getAttribute(attributeName);
            if (attributeValue != null && Hazelcast4IndexedSessionRepository.this.saveMode.equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
                this.delta.put(attributeName, attributeValue);
            }
            return (T)attributeValue;
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.delegate.setAttribute(attributeName, attributeValue);
            this.delta.put(attributeName, attributeValue);
            if (Hazelcast4IndexedSessionRepository.SPRING_SECURITY_CONTEXT.equals(attributeName)) {
                Map indexes = Hazelcast4IndexedSessionRepository.this.indexResolver.resolveIndexesFor((Session)this);
                String principal = attributeValue != null ? (String)indexes.get(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME) : null;
                this.delegate.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)principal);
            }
            this.flushImmediateIfNecessary();
        }

        public void removeAttribute(String attributeName) {
            this.setAttribute(attributeName, null);
        }

        MapSession getDelegate() {
            return this.delegate;
        }

        boolean hasChanges() {
            return this.lastAccessedTimeChanged || this.maxInactiveIntervalChanged || !this.delta.isEmpty();
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.lastAccessedTimeChanged = false;
            this.sessionIdChanged = false;
            this.maxInactiveIntervalChanged = false;
            this.delta.clear();
        }

        private void flushImmediateIfNecessary() {
            if (Hazelcast4IndexedSessionRepository.this.flushMode == FlushMode.IMMEDIATE) {
                Hazelcast4IndexedSessionRepository.this.save(this);
            }
        }
    }
}

