/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast.config.annotation.web.http;

import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.hazelcast.HazelcastFlushMode;
import org.springframework.session.hazelcast.HazelcastSessionRepository;
import org.springframework.session.hazelcast.config.annotation.SpringSessionHazelcastInstance;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;
import org.springframework.util.StringUtils;

@Configuration
public class HazelcastHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String sessionMapName = "spring:session:sessions";
    private HazelcastFlushMode hazelcastFlushMode = HazelcastFlushMode.ON_SAVE;
    private HazelcastInstance hazelcastInstance;
    private ApplicationEventPublisher applicationEventPublisher;

    @Bean
    public HazelcastSessionRepository sessionRepository() {
        HazelcastSessionRepository sessionRepository = new HazelcastSessionRepository(this.hazelcastInstance);
        sessionRepository.setApplicationEventPublisher(this.applicationEventPublisher);
        if (StringUtils.hasText((String)this.sessionMapName)) {
            sessionRepository.setSessionMapName(this.sessionMapName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        sessionRepository.setHazelcastFlushMode(this.hazelcastFlushMode);
        return sessionRepository;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    public void setHazelcastFlushMode(HazelcastFlushMode hazelcastFlushMode) {
        this.hazelcastFlushMode = hazelcastFlushMode;
    }

    @Autowired
    public void setHazelcastInstance(@SpringSessionHazelcastInstance ObjectProvider<HazelcastInstance> springSessionHazelcastInstance, ObjectProvider<HazelcastInstance> hazelcastInstance) {
        HazelcastInstance hazelcastInstanceToUse = (HazelcastInstance)springSessionHazelcastInstance.getIfAvailable();
        if (hazelcastInstanceToUse == null) {
            hazelcastInstanceToUse = (HazelcastInstance)hazelcastInstance.getObject();
        }
        this.hazelcastInstance = hazelcastInstanceToUse;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableHazelcastHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
        String sessionMapNameValue = attributes.getString("sessionMapName");
        if (StringUtils.hasText((String)sessionMapNameValue)) {
            this.sessionMapName = sessionMapNameValue;
        }
        this.hazelcastFlushMode = (HazelcastFlushMode)attributes.getEnum("hazelcastFlushMode");
    }
}

