/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveRedisOperationsSessionRepository
implements ReactiveSessionRepository<RedisSession> {
    public static final String DEFAULT_NAMESPACE = "spring:session";
    static final String CREATION_TIME_KEY = "creationTime";
    static final String LAST_ACCESSED_TIME_KEY = "lastAccessedTime";
    static final String MAX_INACTIVE_INTERVAL_KEY = "maxInactiveInterval";
    static final String ATTRIBUTE_PREFIX = "sessionAttr:";
    private final ReactiveRedisOperations<String, Object> sessionRedisOperations;
    private String namespace = "spring:session:";
    private Integer defaultMaxInactiveInterval;
    private RedisFlushMode redisFlushMode = RedisFlushMode.ON_SAVE;

    public ReactiveRedisOperationsSessionRepository(ReactiveRedisOperations<String, Object> sessionRedisOperations) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations cannot be null");
        this.sessionRedisOperations = sessionRedisOperations;
    }

    public void setRedisKeyNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be null or empty");
        this.namespace = namespace.trim() + ":";
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setRedisFlushMode(RedisFlushMode redisFlushMode) {
        Assert.notNull((Object)((Object)redisFlushMode), (String)"redisFlushMode cannot be null");
        this.redisFlushMode = redisFlushMode;
    }

    public Mono<RedisSession> createSession() {
        return Mono.defer(() -> {
            RedisSession session = new RedisSession();
            if (this.defaultMaxInactiveInterval != null) {
                session.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
            }
            return Mono.just((Object)session);
        });
    }

    public Mono<Void> save(RedisSession session) {
        return session.saveDelta().and(s -> {
            if (session.isNew) {
                session.setNew(false);
            }
            s.onComplete();
        });
    }

    public Mono<RedisSession> findById(String id) {
        String sessionKey = this.getSessionKey(id);
        return this.sessionRedisOperations.opsForHash().entries((Object)sessionKey).collectMap(e -> e.getKey().toString(), Map.Entry::getValue).filter(map -> !map.isEmpty()).map((Function)new SessionMapper(id)).filter(session -> !session.isExpired()).map(x$0 -> new RedisSession((MapSession)x$0)).switchIfEmpty(Mono.defer(() -> this.deleteById(id).then(Mono.empty())));
    }

    public Mono<Void> deleteById(String id) {
        String sessionKey = this.getSessionKey(id);
        return this.sessionRedisOperations.delete((Object[])new String[]{sessionKey}).then();
    }

    private static String getAttributeKey(String attributeName) {
        return ATTRIBUTE_PREFIX + attributeName;
    }

    private String getSessionKey(String sessionId) {
        return this.namespace + "sessions:" + sessionId;
    }

    private static final class SessionMapper
    implements Function<Map<String, Object>, MapSession> {
        private final String id;

        private SessionMapper(String id) {
            this.id = id;
        }

        @Override
        public MapSession apply(Map<String, Object> map) {
            MapSession session = new MapSession(this.id);
            session.setCreationTime(Instant.ofEpochMilli((Long)map.get(ReactiveRedisOperationsSessionRepository.CREATION_TIME_KEY)));
            session.setLastAccessedTime(Instant.ofEpochMilli((Long)map.get(ReactiveRedisOperationsSessionRepository.LAST_ACCESSED_TIME_KEY)));
            session.setMaxInactiveInterval(Duration.ofSeconds(((Integer)map.get(ReactiveRedisOperationsSessionRepository.MAX_INACTIVE_INTERVAL_KEY)).intValue()));
            map.forEach((name, value) -> {
                if (name.startsWith(ReactiveRedisOperationsSessionRepository.ATTRIBUTE_PREFIX)) {
                    session.setAttribute(name.substring(ReactiveRedisOperationsSessionRepository.ATTRIBUTE_PREFIX.length()), value);
                }
            });
            return session;
        }
    }

    final class RedisSession
    implements Session {
        private final MapSession cached;
        private final Map<String, Object> delta = new HashMap<String, Object>();
        private boolean isNew;
        private String originalSessionId;

        RedisSession() {
            this(new MapSession());
            this.delta.put(ReactiveRedisOperationsSessionRepository.CREATION_TIME_KEY, this.getCreationTime().toEpochMilli());
            this.delta.put(ReactiveRedisOperationsSessionRepository.MAX_INACTIVE_INTERVAL_KEY, (int)this.getMaxInactiveInterval().getSeconds());
            this.delta.put(ReactiveRedisOperationsSessionRepository.LAST_ACCESSED_TIME_KEY, this.getLastAccessedTime().toEpochMilli());
            this.isNew = true;
            this.flushImmediateIfNecessary();
        }

        RedisSession(MapSession mapSession) {
            Assert.notNull((Object)mapSession, (String)"mapSession cannot be null");
            this.cached = mapSession;
            this.originalSessionId = mapSession.getId();
        }

        public String getId() {
            return this.cached.getId();
        }

        public String changeSessionId() {
            return this.cached.changeSessionId();
        }

        public <T> T getAttribute(String attributeName) {
            return (T)this.cached.getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.putAndFlush(ReactiveRedisOperationsSessionRepository.getAttributeKey(attributeName), attributeValue);
        }

        public void removeAttribute(String attributeName) {
            this.cached.removeAttribute(attributeName);
            this.putAndFlush(ReactiveRedisOperationsSessionRepository.getAttributeKey(attributeName), null);
        }

        public Instant getCreationTime() {
            return this.cached.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.putAndFlush(ReactiveRedisOperationsSessionRepository.LAST_ACCESSED_TIME_KEY, this.getLastAccessedTime().toEpochMilli());
        }

        public Instant getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.cached.setMaxInactiveInterval(interval);
            this.putAndFlush(ReactiveRedisOperationsSessionRepository.MAX_INACTIVE_INTERVAL_KEY, (int)this.getMaxInactiveInterval().getSeconds());
        }

        public Duration getMaxInactiveInterval() {
            return this.cached.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.cached.isExpired();
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
        }

        public boolean isNew() {
            return this.isNew;
        }

        private void flushImmediateIfNecessary() {
            if (ReactiveRedisOperationsSessionRepository.this.redisFlushMode == RedisFlushMode.IMMEDIATE) {
                this.saveDelta();
            }
        }

        private void putAndFlush(String a, Object v) {
            this.delta.put(a, v);
            this.flushImmediateIfNecessary();
        }

        private Mono<Void> saveDelta() {
            String sessionId = this.getId();
            Mono<Void> changeSessionId = this.saveChangeSessionId(sessionId);
            if (this.delta.isEmpty()) {
                return changeSessionId.and((Publisher)Mono.empty());
            }
            String sessionKey = ReactiveRedisOperationsSessionRepository.this.getSessionKey(sessionId);
            Mono update = ReactiveRedisOperationsSessionRepository.this.sessionRedisOperations.opsForHash().putAll((Object)sessionKey, this.delta);
            Mono setTtl = ReactiveRedisOperationsSessionRepository.this.sessionRedisOperations.expire((Object)sessionKey, this.getMaxInactiveInterval());
            return changeSessionId.and((Publisher)update).and((Publisher)setTtl).and(s -> {
                this.delta.clear();
                s.onComplete();
            }).then();
        }

        private Mono<Void> saveChangeSessionId(String sessionId) {
            if (sessionId.equals(this.originalSessionId)) {
                return Mono.empty();
            }
            Publisher replaceSessionId = s -> {
                this.originalSessionId = sessionId;
                s.onComplete();
            };
            if (this.isNew()) {
                return Mono.from((Publisher)replaceSessionId);
            }
            String originalSessionKey = ReactiveRedisOperationsSessionRepository.this.getSessionKey(this.originalSessionId);
            String sessionKey = ReactiveRedisOperationsSessionRepository.this.getSessionKey(sessionId);
            return ReactiveRedisOperationsSessionRepository.this.sessionRedisOperations.rename((Object)originalSessionKey, (Object)sessionKey).and(replaceSessionId);
        }
    }
}

