/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.springframework.security.web.webauthn.api.CredProtectAuthenticationExtensionsClientInput;

@Deprecated(forRemoval=true)
class CredProtectAuthenticationExtensionsClientInputJackson2Serializer
extends StdSerializer<CredProtectAuthenticationExtensionsClientInput> {
    protected CredProtectAuthenticationExtensionsClientInputJackson2Serializer() {
        super(CredProtectAuthenticationExtensionsClientInput.class);
    }

    public void serialize(CredProtectAuthenticationExtensionsClientInput input, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        CredProtectAuthenticationExtensionsClientInput.CredProtect credProtect = input.getInput();
        String policy = CredProtectAuthenticationExtensionsClientInputJackson2Serializer.toString(credProtect.getCredProtectionPolicy());
        jgen.writeObjectField("credentialProtectionPolicy", (Object)policy);
        jgen.writeObjectField("enforceCredentialProtectionPolicy", (Object)credProtect.isEnforceCredentialProtectionPolicy());
    }

    private static String toString(CredProtectAuthenticationExtensionsClientInput.CredProtect.ProtectionPolicy policy) {
        switch (policy) {
            case USER_VERIFICATION_OPTIONAL: {
                return "userVerificationOptional";
            }
            case USER_VERIFICATION_OPTIONAL_WITH_CREDENTIAL_ID_LIST: {
                return "userVerificationOptionalWithCredentialIdList";
            }
            case USER_VERIFICATION_REQUIRED: {
                return "userVerificationRequired";
            }
        }
        throw new IllegalArgumentException("Unsupported ProtectionPolicy " + String.valueOf((Object)policy));
    }
}

