/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractSmartHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpMessageConverterAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.webauthn.api.AuthenticatorAssertionResponse;
import org.springframework.security.web.webauthn.api.PublicKeyCredential;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRequestOptions;
import org.springframework.security.web.webauthn.authentication.HttpSessionPublicKeyCredentialRequestOptionsRepository;
import org.springframework.security.web.webauthn.authentication.PublicKeyCredentialRequestOptionsRepository;
import org.springframework.security.web.webauthn.authentication.WebAuthnAuthenticationRequestToken;
import org.springframework.security.web.webauthn.jackson.WebauthnJacksonModule;
import org.springframework.security.web.webauthn.management.RelyingPartyAuthenticationRequest;
import org.springframework.util.Assert;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;

public class WebAuthnAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private SmartHttpMessageConverter<Object> converter = new JacksonJsonHttpMessageConverter(((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)new WebauthnJacksonModule())).build());
    private PublicKeyCredentialRequestOptionsRepository requestOptionsRepository = new HttpSessionPublicKeyCredentialRequestOptionsRepository();

    public WebAuthnAuthenticationFilter() {
        super((RequestMatcher)PathPatternRequestMatcher.pathPattern((HttpMethod)HttpMethod.POST, (String)"/login/webauthn"));
        this.setSecurityContextRepository((SecurityContextRepository)new HttpSessionSecurityContextRepository());
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new AuthenticationEntryPointFailureHandler((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED)));
        this.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new HttpMessageConverterAuthenticationSuccessHandler());
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(PublicKeyCredential.class, (Class[])new Class[]{AuthenticatorAssertionResponse.class});
        PublicKeyCredential publicKeyCredential = null;
        try {
            publicKeyCredential = (PublicKeyCredential)this.converter.read(resolvableType, (HttpInputMessage)httpRequest, null);
        }
        catch (Exception ex) {
            throw new BadCredentialsException("Unable to authenticate the PublicKeyCredential", (Throwable)ex);
        }
        PublicKeyCredentialRequestOptions requestOptions = this.requestOptionsRepository.load(request);
        if (requestOptions == null) {
            throw new BadCredentialsException("Unable to authenticate the PublicKeyCredential. No PublicKeyCredentialRequestOptions found.");
        }
        this.requestOptionsRepository.save(request, response, null);
        RelyingPartyAuthenticationRequest authenticationRequest = new RelyingPartyAuthenticationRequest(requestOptions, publicKeyCredential);
        WebAuthnAuthenticationRequestToken token = new WebAuthnAuthenticationRequestToken(authenticationRequest);
        return this.getAuthenticationManager().authenticate((Authentication)token);
    }

    @Deprecated(forRemoval=true, since="7.0")
    public void setConverter(GenericHttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = new GenericHttpMessageConverterAdapter<Object>(converter);
    }

    public void setConverter(SmartHttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = converter;
    }

    public void setRequestOptionsRepository(PublicKeyCredentialRequestOptionsRepository requestOptionsRepository) {
        Assert.notNull((Object)requestOptionsRepository, (String)"requestOptionsRepository cannot be null");
        this.requestOptionsRepository = requestOptionsRepository;
    }

    private static final class GenericHttpMessageConverterAdapter<T>
    extends AbstractSmartHttpMessageConverter<T> {
        private final GenericHttpMessageConverter<T> delegate;

        private GenericHttpMessageConverterAdapter(GenericHttpMessageConverter<T> delegate) {
            Assert.notNull(delegate, (String)"delegate cannot be null");
            this.delegate = delegate;
        }

        public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
            return this.delegate.canRead(clazz, mediaType);
        }

        public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
            return this.delegate.canWrite(clazz, mediaType);
        }

        public List<MediaType> getSupportedMediaTypes() {
            return this.delegate.getSupportedMediaTypes();
        }

        public List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
            return this.delegate.getSupportedMediaTypes(clazz);
        }

        protected void writeInternal(T t, ResolvableType type, HttpOutputMessage outputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
            this.delegate.write(t, null, outputMessage);
        }

        public T read(ResolvableType type, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
            return (T)this.delegate.read(type.getType(), null, inputMessage);
        }
    }
}

