/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.io.Serializable;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;

public final class PublicKeyCredentialDescriptor
implements Serializable {
    private static final long serialVersionUID = 8793385059692676240L;
    private final PublicKeyCredentialType type;
    private final @Nullable Bytes id;
    private final @Nullable Set<AuthenticatorTransport> transports;

    private PublicKeyCredentialDescriptor(PublicKeyCredentialType type, @Nullable Bytes id, @Nullable Set<AuthenticatorTransport> transports) {
        this.type = type;
        this.id = id;
        this.transports = transports;
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public @Nullable Bytes getId() {
        return this.id;
    }

    public @Nullable Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public static PublicKeyCredentialDescriptorBuilder builder() {
        return new PublicKeyCredentialDescriptorBuilder();
    }

    public static final class PublicKeyCredentialDescriptorBuilder {
        private PublicKeyCredentialType type = PublicKeyCredentialType.PUBLIC_KEY;
        private @Nullable Bytes id;
        private @Nullable Set<AuthenticatorTransport> transports;

        private PublicKeyCredentialDescriptorBuilder() {
        }

        public PublicKeyCredentialDescriptorBuilder type(PublicKeyCredentialType type) {
            this.type = type;
            return this;
        }

        public PublicKeyCredentialDescriptorBuilder id(Bytes id) {
            this.id = id;
            return this;
        }

        public PublicKeyCredentialDescriptorBuilder transports(Set<AuthenticatorTransport> transports) {
            this.transports = transports;
            return this;
        }

        public PublicKeyCredentialDescriptorBuilder transports(AuthenticatorTransport ... transports) {
            return this.transports(Set.of(transports));
        }

        public PublicKeyCredentialDescriptor build() {
            return new PublicKeyCredentialDescriptor(this.type, this.id, this.transports);
        }
    }
}

