/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

public final class AuthorizationManagerWebInvocationPrivilegeEvaluator
implements WebInvocationPrivilegeEvaluator,
ServletContextAware {
    private final AuthorizationManager<HttpServletRequest> authorizationManager;
    private @Nullable ServletContext servletContext;
    private HttpServletRequestTransformer requestTransformer = HttpServletRequestTransformer.IDENTITY;

    public AuthorizationManagerWebInvocationPrivilegeEvaluator(AuthorizationManager<HttpServletRequest> authorizationManager) {
        Assert.notNull(authorizationManager, (String)"authorizationManager cannot be null");
        this.authorizationManager = authorizationManager;
    }

    @Override
    public boolean isAllowed(String uri, @Nullable Authentication authentication) {
        return this.isAllowed(null, uri, null, authentication);
    }

    @Override
    public boolean isAllowed(@Nullable String contextPath, String uri, @Nullable String method, @Nullable Authentication authentication) {
        FilterInvocation filterInvocation = new FilterInvocation(contextPath, uri, method, this.servletContext);
        HttpServletRequest httpRequest = this.requestTransformer.transform(filterInvocation.getHttpRequest());
        AuthorizationResult result = this.authorizationManager.authorize(() -> authentication, (Object)httpRequest);
        return result == null || result.isGranted();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setRequestTransformer(HttpServletRequestTransformer requestTransformer) {
        Assert.notNull((Object)requestTransformer, (String)"requestTransformer cannot be null");
        this.requestTransformer = requestTransformer;
    }

    public static interface HttpServletRequestTransformer {
        public static final HttpServletRequestTransformer IDENTITY = request -> request;

        public HttpServletRequest transform(HttpServletRequest var1);
    }
}

