/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ExpressionAuthorizationDecision;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.expression.DefaultHttpSecurityExpressionHandler;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.util.Assert;

public final class WebExpressionAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    private SecurityExpressionHandler<RequestAuthorizationContext> expressionHandler = new DefaultHttpSecurityExpressionHandler();
    private Expression expression;

    public WebExpressionAuthorizationManager(String expressionString) {
        Assert.hasText((String)expressionString, (String)"expressionString cannot be empty");
        this.expression = this.expressionHandler.getExpressionParser().parseExpression(expressionString);
    }

    private WebExpressionAuthorizationManager(String expressionString, SecurityExpressionHandler<RequestAuthorizationContext> expressionHandler) {
        Assert.hasText((String)expressionString, (String)"expressionString cannot be empty");
        this.expressionHandler = expressionHandler;
        this.expression = expressionHandler.getExpressionParser().parseExpression(expressionString);
    }

    @Deprecated
    public void setExpressionHandler(SecurityExpressionHandler<RequestAuthorizationContext> expressionHandler) {
        Assert.notNull(expressionHandler, (String)"expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
        this.expression = expressionHandler.getExpressionParser().parseExpression(this.expression.getExpressionString());
    }

    public AuthorizationResult authorize(Supplier<Authentication> authentication, RequestAuthorizationContext context) {
        EvaluationContext ctx = this.expressionHandler.createEvaluationContext(authentication, (Object)context);
        boolean granted = ExpressionUtils.evaluateAsBoolean((Expression)this.expression, (EvaluationContext)ctx);
        return new ExpressionAuthorizationDecision(granted, this.expression);
    }

    public String toString() {
        return "WebExpressionAuthorizationManager[expression='" + String.valueOf(this.expression) + "']";
    }

    public static Builder withDefaults() {
        return new Builder();
    }

    public static Builder withExpressionHandler(SecurityExpressionHandler<RequestAuthorizationContext> expressionHandler) {
        return new Builder(expressionHandler);
    }

    public static final class Builder
    implements ApplicationContextAware {
        private final SecurityExpressionHandler<RequestAuthorizationContext> expressionHandler;
        private final boolean defaultExpressionHandler;

        private Builder() {
            this.expressionHandler = new DefaultHttpSecurityExpressionHandler();
            this.defaultExpressionHandler = true;
        }

        private Builder(SecurityExpressionHandler<RequestAuthorizationContext> expressionHandler) {
            this.expressionHandler = expressionHandler;
            this.defaultExpressionHandler = false;
        }

        public WebExpressionAuthorizationManager expression(String expression) {
            return new WebExpressionAuthorizationManager(expression, this.expressionHandler);
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            if (this.defaultExpressionHandler) {
                ((DefaultHttpSecurityExpressionHandler)this.expressionHandler).setApplicationContext(context);
            }
        }
    }
}

