/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;

public final class UrlUtils {
    private static final Pattern ABSOLUTE_URL = Pattern.compile("\\A[a-z0-9.+-]+://.*", 2);

    private UrlUtils() {
    }

    public static String buildFullRequestUrl(HttpServletRequest r) {
        return UrlUtils.buildFullRequestUrl(r.getScheme(), r.getServerName(), r.getServerPort(), r.getRequestURI(), r.getQueryString());
    }

    public static String buildFullRequestUrl(String scheme, String serverName, int serverPort, String requestURI, String queryString) {
        scheme = scheme.toLowerCase();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if ("http".equals(scheme)) {
            if (serverPort != 80) {
                url.append(":").append(serverPort);
            }
        } else if ("https".equals(scheme) && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(requestURI);
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }

    public static String buildRequestUrl(HttpServletRequest r) {
        return UrlUtils.buildRequestUrl(r.getServletPath(), r.getRequestURI(), r.getContextPath(), r.getPathInfo(), r.getQueryString());
    }

    private static String buildRequestUrl(String servletPath, String requestURI, String contextPath, String pathInfo, String queryString) {
        StringBuilder url = new StringBuilder();
        if (servletPath != null) {
            url.append(servletPath);
            if (pathInfo != null) {
                url.append(pathInfo);
            }
        } else {
            url.append(requestURI.substring(contextPath.length()));
        }
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }

    public static boolean isValidRedirectUrl(String url) {
        return url != null && (url.startsWith("/") || UrlUtils.isAbsoluteUrl(url));
    }

    public static boolean isAbsoluteUrl(String url) {
        return url != null ? ABSOLUTE_URL.matcher(url).matches() : false;
    }
}

