/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class SecurityContextHolderFilter
extends OncePerRequestFilter {
    private final SecurityContextRepository securityContextRepository;
    private boolean shouldNotFilterErrorDispatch;

    public SecurityContextHolderFilter(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SecurityContext securityContext = this.securityContextRepository.loadContext(new HttpRequestResponseHolder(request, response));
        try {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return this.shouldNotFilterErrorDispatch;
    }

    public void setShouldNotFilterErrorDispatch(boolean shouldNotFilterErrorDispatch) {
        this.shouldNotFilterErrorDispatch = shouldNotFilterErrorDispatch;
    }
}

