/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.web.context.support.SecurityWebApplicationContextUtils;
import org.springframework.security.web.session.HttpSessionCreatedEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.security.web.session.HttpSessionIdChangedEvent;

public class HttpSessionEventPublisher
implements HttpSessionListener,
HttpSessionIdListener {
    private static final String LOGGER_NAME = HttpSessionEventPublisher.class.getName();

    ApplicationContext getContext(ServletContext servletContext) {
        return SecurityWebApplicationContextUtils.findRequiredWebApplicationContext(servletContext);
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSessionCreatedEvent e = new HttpSessionCreatedEvent(event.getSession());
        Log log = LogFactory.getLog((String)LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publishing event: " + (Object)((Object)e)));
        }
        this.getContext(event.getSession().getServletContext()).publishEvent((ApplicationEvent)e);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSessionDestroyedEvent e = new HttpSessionDestroyedEvent(event.getSession());
        Log log = LogFactory.getLog((String)LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publishing event: " + (Object)((Object)e)));
        }
        this.getContext(event.getSession().getServletContext()).publishEvent((ApplicationEvent)e);
    }

    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        HttpSessionIdChangedEvent e = new HttpSessionIdChangedEvent(event.getSession(), oldSessionId);
        Log log = LogFactory.getLog((String)LOGGER_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publishing event: " + (Object)((Object)e)));
        }
        this.getContext(event.getSession().getServletContext()).publishEvent((ApplicationEvent)e);
    }
}

