/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.RequestRejectedHandler;

public class HttpStatusRequestRejectedHandler
implements RequestRejectedHandler {
    private static final Log logger = LogFactory.getLog(HttpStatusRequestRejectedHandler.class);
    private final int httpError;

    public HttpStatusRequestRejectedHandler() {
        this.httpError = 400;
    }

    public HttpStatusRequestRejectedHandler(int httpError) {
        this.httpError = httpError;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, RequestRejectedException requestRejectedException) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rejecting request due to: " + requestRejectedException.getMessage()), (Throwable)requestRejectedException);
        }
        response.sendError(this.httpError);
    }
}

