/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebSessionServerSecurityContextRepository
implements ServerSecurityContextRepository {
    private static final Log logger = LogFactory.getLog(WebSessionServerSecurityContextRepository.class);
    public static final String DEFAULT_SPRING_SECURITY_CONTEXT_ATTR_NAME = "SPRING_SECURITY_CONTEXT";
    private String springSecurityContextAttrName = "SPRING_SECURITY_CONTEXT";

    public void setSpringSecurityContextAttrName(String springSecurityContextAttrName) {
        Assert.hasText((String)springSecurityContextAttrName, (String)"springSecurityContextAttrName cannot be null or empty");
        this.springSecurityContextAttrName = springSecurityContextAttrName;
    }

    @Override
    public Mono<Void> save(ServerWebExchange exchange, SecurityContext context) {
        return exchange.getSession().doOnNext(session -> {
            if (context == null) {
                session.getAttributes().remove(this.springSecurityContextAttrName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed SecurityContext stored in WebSession: '" + session + "'"));
                }
            } else {
                session.getAttributes().put(this.springSecurityContextAttrName, context);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Saved SecurityContext '" + context + "' in WebSession: '" + session + "'"));
                }
            }
        }).flatMap(session -> session.changeSessionId());
    }

    @Override
    public Mono<SecurityContext> load(ServerWebExchange exchange) {
        return exchange.getSession().flatMap(session -> {
            SecurityContext context = (SecurityContext)session.getAttribute(this.springSecurityContextAttrName);
            if (logger.isDebugEnabled()) {
                if (context == null) {
                    logger.debug((Object)("No SecurityContext found in WebSession: '" + session + "'"));
                } else {
                    logger.debug((Object)("Found SecurityContext '" + context + "' in WebSession: '" + session + "'"));
                }
            }
            return Mono.justOrEmpty((Object)context);
        });
    }
}

