/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

final class UnsupportedOperationExceptionInvocationHandler
implements InvocationHandler {
    private static final float JAVA_VERSION = Float.parseFloat(System.getProperty("java.class.version", "52"));

    UnsupportedOperationExceptionInvocationHandler() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return this.invokeDefaultMethod(proxy, method, args);
        }
        throw new UnsupportedOperationException(method + " is not supported");
    }

    private Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isJdk8OrEarlier()) {
            return this.invokeDefaultMethodForJdk8(proxy, method, args);
        }
        return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
    }

    private Object invokeDefaultMethodForJdk8(Object proxy, Method method, Object[] args) throws Throwable {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
        constructor.setAccessible(true);
        Class<?> clazz = method.getDeclaringClass();
        return ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
    }

    private boolean isJdk8OrEarlier() {
        return JAVA_VERSION <= 52.0f;
    }
}

