/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.RedirectStrategy;

public class DefaultRedirectStrategy
implements RedirectStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean contextRelative;

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String finalUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            finalUrl = this.contextRelative ? url : request.getContextPath() + url;
        } else if (this.contextRelative) {
            int len = request.getContextPath().length();
            int index = url.indexOf(request.getContextPath()) + len;
            finalUrl = url.substring(index);
            if (finalUrl.length() > 1 && finalUrl.charAt(0) == '/') {
                finalUrl = finalUrl.substring(1);
            }
        } else {
            finalUrl = url;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting to '" + finalUrl + "'"));
        }
        response.sendRedirect(response.encodeRedirectURL(finalUrl));
    }

    public void setContextRelative(boolean useRelativeContext) {
        this.contextRelative = useRelativeContext;
    }
}

