package org.springframework.security.web.authentication.preauth.x509;

import java.security.cert.X509Certificate;

/**
 * Obtains the principal from an X509Certificate for use within the framework.
 *
 * @author Luke Taylor
 * @version $Id: X509PrincipalExtractor.java 3543 2009-03-26 07:18:36Z ltaylor $
 */
public interface X509PrincipalExtractor {

    /**
     * Returns the principal (usually a String) for the given certificate.
     */
    Object extractPrincipal(X509Certificate cert);
}
