/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.core.userdetails.cache.NullUserCache;
import org.springframework.security.web.FilterChainOrder;
import org.springframework.security.web.SpringSecurityFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.www.DigestAuthUtils;
import org.springframework.security.web.authentication.www.DigestProcessingFilterEntryPoint;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DigestProcessingFilter
extends SpringSecurityFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog(DigestProcessingFilter.class);
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private DigestProcessingFilterEntryPoint authenticationEntryPoint;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private UserCache userCache = new NullUserCache();
    private UserDetailsService userDetailsService;
    private boolean passwordAlreadyEncoded = false;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService is required");
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"A DigestProcessingFilterEntryPoint is required");
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String header = request.getHeader("Authorization");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header received from user agent: " + header));
        }
        if (header != null && header.startsWith("Digest ")) {
            String serverDigestMd5;
            long nonceExpiryTime;
            String section212response = header.substring(7);
            String[] headerEntries = DigestAuthUtils.splitIgnoringQuotes(section212response, ',');
            Map<String, String> headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap(headerEntries, "=", "\"");
            String username = headerMap.get("username");
            String realm = headerMap.get("realm");
            String nonce = headerMap.get("nonce");
            String uri = headerMap.get("uri");
            String responseDigest = headerMap.get("response");
            String qop = headerMap.get("qop");
            String nc = headerMap.get("nc");
            String cnonce = headerMap.get("cnonce");
            if (username == null || realm == null || nonce == null || uri == null || response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("extracted username: '" + username + "'; realm: '" + username + "'; nonce: '" + username + "'; uri: '" + username + "'; response: '" + username + "'"));
                }
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.missingMandatory", new Object[]{section212response}, "Missing mandatory digest value; received header {0}")));
                return;
            }
            if ("auth".equals(qop) && (nc == null || cnonce == null)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("extracted nc: '" + nc + "'; cnonce: '" + cnonce + "'"));
                }
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.missingAuth", new Object[]{section212response}, "Missing mandatory digest value; received header {0}")));
                return;
            }
            if (!this.getAuthenticationEntryPoint().getRealmName().equals(realm)) {
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.incorrectRealm", new Object[]{realm, this.getAuthenticationEntryPoint().getRealmName()}, "Response realm name '{0}' does not match system realm name of '{1}'")));
                return;
            }
            if (!Base64.isArrayByteBase64((byte[])nonce.getBytes())) {
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceEncoding", new Object[]{nonce}, "Nonce is not encoded in Base64; received nonce {0}")));
                return;
            }
            String nonceAsPlainText = new String(Base64.decodeBase64((byte[])nonce.getBytes()));
            String[] nonceTokens = StringUtils.delimitedListToStringArray((String)nonceAsPlainText, (String)":");
            if (nonceTokens.length != 2) {
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceNotTwoTokens", new Object[]{nonceAsPlainText}, "Nonce should have yielded two tokens but was {0}")));
                return;
            }
            try {
                nonceExpiryTime = new Long(nonceTokens[0]);
            }
            catch (NumberFormatException nfe) {
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceNotNumeric", new Object[]{nonceAsPlainText}, "Nonce token should have yielded a numeric first token, but was {0}")));
                return;
            }
            String expectedNonceSignature = DigestUtils.md5Hex((String)(nonceExpiryTime + ":" + this.getAuthenticationEntryPoint().getKey()));
            if (!expectedNonceSignature.equals(nonceTokens[1])) {
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceCompromised", new Object[]{nonceAsPlainText}, "Nonce token compromised {0}")));
                return;
            }
            boolean loadedFromDao = false;
            UserDetails user = this.userCache.getUserFromCache(username);
            if (user == null) {
                loadedFromDao = true;
                try {
                    user = this.userDetailsService.loadUserByUsername(username);
                }
                catch (UsernameNotFoundException notFound) {
                    this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.usernameNotFound", new Object[]{username}, "Username {0} not found")));
                    return;
                }
                if (user == null) {
                    throw new AuthenticationServiceException("AuthenticationDao returned null, which is an interface contract violation");
                }
                this.userCache.putUserInCache(user);
            }
            if (!(serverDigestMd5 = DigestAuthUtils.generateDigest(this.passwordAlreadyEncoded, username, realm, user.getPassword(), request.getMethod(), uri, qop, nonce, nc, cnonce)).equals(responseDigest) && !loadedFromDao) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Digest comparison failure; trying to refresh user from DAO in case password had changed");
                }
                try {
                    user = this.userDetailsService.loadUserByUsername(username);
                }
                catch (UsernameNotFoundException notFound) {
                    this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.usernameNotFound", new Object[]{username}, "Username {0} not found")));
                }
                this.userCache.putUserInCache(user);
                serverDigestMd5 = DigestAuthUtils.generateDigest(this.passwordAlreadyEncoded, username, realm, user.getPassword(), request.getMethod(), uri, qop, nonce, nc, cnonce);
            }
            if (!serverDigestMd5.equals(responseDigest)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Expected response: '" + serverDigestMd5 + "' but received: '" + responseDigest + "'; is AuthenticationDao returning clear text passwords?"));
                }
                this.fail(request, response, (AuthenticationException)new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.incorrectResponse", "Incorrect response")));
                return;
            }
            if (nonceExpiryTime < System.currentTimeMillis()) {
                this.fail(request, response, new NonceExpiredException(this.messages.getMessage("DigestProcessingFilter.nonceExpired", "Nonce has expired/timed out")));
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success for user: '" + username + "' with response: '" + responseDigest + "'"));
            }
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword());
            authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void fail(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)failed);
        }
        this.authenticationEntryPoint.commence(request, response, failed);
    }

    public DigestProcessingFilterEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationEntryPoint(DigestProcessingFilterEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setPasswordAlreadyEncoded(boolean passwordAlreadyEncoded) {
        this.passwordAlreadyEncoded = passwordAlreadyEncoded;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public int getOrder() {
        return FilterChainOrder.DIGEST_PROCESSING_FILTER;
    }
}

