/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.aot.hint;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.test.context.aot.TestRuntimeHintsRegistrar;

class WebTestUtilsTestRuntimeHints
implements TestRuntimeHintsRegistrar {
    WebTestUtilsTestRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, Class<?> testClass, ClassLoader classLoader) {
        this.registerFilterChainProxyHints(hints);
        this.registerSecurityContextRepositoryHints(hints);
        this.registerCsrfTokenRepositoryHints(hints);
    }

    private void registerFilterChainProxyHints(RuntimeHints hints) {
        hints.reflection().registerType(FilterChainProxy.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
    }

    private void registerCsrfTokenRepositoryHints(RuntimeHints hints) {
        hints.reflection().registerType(CsrfFilter.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS});
    }

    private void registerSecurityContextRepositoryHints(RuntimeHints hints) {
        hints.reflection().registerType(SecurityContextPersistenceFilter.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS});
        hints.reflection().registerType(SecurityContextHolderFilter.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS});
    }
}

