/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.util.Assert;

public final class CacheSaml2AuthenticationRequestRepository
implements Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> {
    private Cache cache = new ConcurrentMapCache("authentication-requests");

    @Override
    public AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        String relayState = request.getParameter("RelayState");
        Assert.notNull((Object)relayState, (String)"relayState must not be null");
        return (AbstractSaml2AuthenticationRequest)this.cache.get((Object)relayState, AbstractSaml2AuthenticationRequest.class);
    }

    @Override
    public void saveAuthenticationRequest(AbstractSaml2AuthenticationRequest authenticationRequest, HttpServletRequest request, HttpServletResponse response) {
        String relayState = request.getParameter("RelayState");
        Assert.notNull((Object)relayState, (String)"relayState must not be null");
        this.cache.put((Object)relayState, (Object)authenticationRequest);
    }

    @Override
    public AbstractSaml2AuthenticationRequest removeAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) {
        String relayState = request.getParameter("RelayState");
        Assert.notNull((Object)relayState, (String)"relayState must not be null");
        AbstractSaml2AuthenticationRequest authenticationRequest = (AbstractSaml2AuthenticationRequest)this.cache.get((Object)relayState, AbstractSaml2AuthenticationRequest.class);
        if (authenticationRequest == null) {
            return null;
        }
        this.cache.evict((Object)relayState);
        return authenticationRequest;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

