/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public final class OpenSamlAssertingPartyDetails
extends RelyingPartyRegistration.AssertingPartyDetails {
    private final EntityDescriptor descriptor;

    OpenSamlAssertingPartyDetails(RelyingPartyRegistration.AssertingPartyDetails details, EntityDescriptor descriptor) {
        super(details.getEntityId(), details.getWantAuthnRequestsSigned(), details.getSigningAlgorithms(), details.getVerificationX509Credentials(), details.getEncryptionX509Credentials(), details.getSingleSignOnServiceLocation(), details.getSingleSignOnServiceBinding(), details.getSingleLogoutServiceLocation(), details.getSingleLogoutServiceResponseLocation(), details.getSingleLogoutServiceBinding());
        this.descriptor = descriptor;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    public static Builder withEntityDescriptor(EntityDescriptor entity) {
        Saml2MessageBinding binding;
        IDPSSODescriptor idpssoDescriptor = entity.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new Saml2Exception("Metadata response is missing the necessary IDPSSODescriptor element");
        }
        ArrayList<Saml2X509Credential> verification = new ArrayList<Saml2X509Credential>();
        ArrayList<Saml2X509Credential> encryption = new ArrayList<Saml2X509Credential>();
        for (KeyDescriptor keyDescriptor : idpssoDescriptor.getKeyDescriptors()) {
            List<X509Certificate> certificates;
            if (keyDescriptor.getUse().equals((Object)UsageType.SIGNING)) {
                certificates = OpenSamlAssertingPartyDetails.certificates(keyDescriptor);
                for (X509Certificate certificate : certificates) {
                    verification.add(Saml2X509Credential.verification(certificate));
                }
            }
            if (keyDescriptor.getUse().equals((Object)UsageType.ENCRYPTION)) {
                certificates = OpenSamlAssertingPartyDetails.certificates(keyDescriptor);
                for (X509Certificate certificate : certificates) {
                    encryption.add(Saml2X509Credential.encryption(certificate));
                }
            }
            if (!keyDescriptor.getUse().equals((Object)UsageType.UNSPECIFIED)) continue;
            certificates = OpenSamlAssertingPartyDetails.certificates(keyDescriptor);
            for (X509Certificate certificate : certificates) {
                verification.add(Saml2X509Credential.verification(certificate));
                encryption.add(Saml2X509Credential.encryption(certificate));
            }
        }
        if (verification.isEmpty()) {
            throw new Saml2Exception("Metadata response is missing verification certificates, necessary for verifying SAML assertions");
        }
        RelyingPartyRegistration.AssertingPartyDetails.Builder builder = ((Builder)new Builder(entity).entityId(entity.getEntityID()).wantAuthnRequestsSigned(Boolean.TRUE.equals(idpssoDescriptor.getWantAuthnRequestsSigned())).verificationX509Credentials(c -> c.addAll(verification))).encryptionX509Credentials(c -> c.addAll(encryption));
        List<SigningMethod> signingMethods = OpenSamlAssertingPartyDetails.signingMethods(idpssoDescriptor);
        for (SigningMethod method : signingMethods) {
            ((Builder)builder).signingAlgorithms(algorithms -> algorithms.add(method.getAlgorithm()));
        }
        if (idpssoDescriptor.getSingleSignOnServices().isEmpty()) {
            throw new Saml2Exception("Metadata response is missing a SingleSignOnService, necessary for sending AuthnRequests");
        }
        for (SingleSignOnService singleSignOnService : idpssoDescriptor.getSingleSignOnServices()) {
            if (singleSignOnService.getBinding().equals(Saml2MessageBinding.POST.getUrn())) {
                binding = Saml2MessageBinding.POST;
            } else {
                if (!singleSignOnService.getBinding().equals(Saml2MessageBinding.REDIRECT.getUrn())) continue;
                binding = Saml2MessageBinding.REDIRECT;
            }
            ((Builder)builder).singleSignOnServiceLocation(singleSignOnService.getLocation()).singleSignOnServiceBinding(binding);
            break;
        }
        for (SingleLogoutService singleLogoutService : idpssoDescriptor.getSingleLogoutServices()) {
            if (singleLogoutService.getBinding().equals(Saml2MessageBinding.POST.getUrn())) {
                binding = Saml2MessageBinding.POST;
            } else {
                if (!singleLogoutService.getBinding().equals(Saml2MessageBinding.REDIRECT.getUrn())) continue;
                binding = Saml2MessageBinding.REDIRECT;
            }
            String responseLocation = singleLogoutService.getResponseLocation() == null ? singleLogoutService.getLocation() : singleLogoutService.getResponseLocation();
            ((Builder)builder).singleLogoutServiceLocation(singleLogoutService.getLocation()).singleLogoutServiceResponseLocation(responseLocation).singleLogoutServiceBinding(binding);
            break;
        }
        return builder;
    }

    private static List<X509Certificate> certificates(KeyDescriptor keyDescriptor) {
        try {
            return KeyInfoSupport.getCertificates((KeyInfo)keyDescriptor.getKeyInfo());
        }
        catch (CertificateException ex) {
            throw new Saml2Exception(ex);
        }
    }

    private static List<SigningMethod> signingMethods(IDPSSODescriptor idpssoDescriptor) {
        Extensions extensions = idpssoDescriptor.getExtensions();
        List<SigningMethod> result = OpenSamlAssertingPartyDetails.signingMethods(extensions);
        if (!result.isEmpty()) {
            return result;
        }
        EntityDescriptor descriptor = (EntityDescriptor)idpssoDescriptor.getParent();
        extensions = descriptor.getExtensions();
        return OpenSamlAssertingPartyDetails.signingMethods(extensions);
    }

    private static <T> List<T> signingMethods(Extensions extensions) {
        if (extensions != null) {
            return extensions.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME);
        }
        return new ArrayList();
    }

    @Override
    public Builder mutate() {
        return ((Builder)((Builder)((Builder)new Builder(this.descriptor).entityId(this.getEntityId()).wantAuthnRequestsSigned(this.getWantAuthnRequestsSigned()).signingAlgorithms(algorithms -> algorithms.addAll(this.getSigningAlgorithms()))).verificationX509Credentials(c -> c.addAll(this.getVerificationX509Credentials()))).encryptionX509Credentials(c -> c.addAll(this.getEncryptionX509Credentials()))).singleSignOnServiceLocation(this.getSingleSignOnServiceLocation()).singleSignOnServiceBinding(this.getSingleSignOnServiceBinding()).singleLogoutServiceLocation(this.getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(this.getSingleLogoutServiceResponseLocation()).singleLogoutServiceBinding(this.getSingleLogoutServiceBinding());
    }

    public static final class Builder
    extends RelyingPartyRegistration.AssertingPartyDetails.Builder {
        private EntityDescriptor descriptor;

        private Builder(EntityDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public Builder entityId(String entityId) {
            return (Builder)super.entityId(entityId);
        }

        @Override
        public Builder wantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
            return (Builder)super.wantAuthnRequestsSigned(wantAuthnRequestsSigned);
        }

        @Override
        public Builder signingAlgorithms(Consumer<List<String>> signingMethodAlgorithmsConsumer) {
            return (Builder)super.signingAlgorithms((Consumer)signingMethodAlgorithmsConsumer);
        }

        @Override
        public Builder verificationX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            return (Builder)super.verificationX509Credentials((Consumer)credentialsConsumer);
        }

        @Override
        public Builder encryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            return (Builder)super.encryptionX509Credentials((Consumer)credentialsConsumer);
        }

        @Override
        public Builder singleSignOnServiceLocation(String singleSignOnServiceLocation) {
            return (Builder)super.singleSignOnServiceLocation(singleSignOnServiceLocation);
        }

        @Override
        public Builder singleSignOnServiceBinding(Saml2MessageBinding singleSignOnServiceBinding) {
            return (Builder)super.singleSignOnServiceBinding(singleSignOnServiceBinding);
        }

        @Override
        public Builder singleLogoutServiceLocation(String singleLogoutServiceLocation) {
            return (Builder)super.singleLogoutServiceLocation(singleLogoutServiceLocation);
        }

        @Override
        public Builder singleLogoutServiceResponseLocation(String singleLogoutServiceResponseLocation) {
            return (Builder)super.singleLogoutServiceResponseLocation(singleLogoutServiceResponseLocation);
        }

        @Override
        public Builder singleLogoutServiceBinding(Saml2MessageBinding singleLogoutServiceBinding) {
            return (Builder)super.singleLogoutServiceBinding(singleLogoutServiceBinding);
        }

        @Override
        public OpenSamlAssertingPartyDetails build() {
            return new OpenSamlAssertingPartyDetails(super.build(), this.descriptor);
        }
    }
}

