/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.io.Serializable;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;

public abstract class AbstractSaml2AuthenticationRequest
implements Serializable {
    private static final long serialVersionUID = 620L;
    private final String samlRequest;
    private final String relayState;
    private final String authenticationRequestUri;
    private final String relyingPartyRegistrationId;
    private final String id;

    AbstractSaml2AuthenticationRequest(String samlRequest, String relayState, String authenticationRequestUri, String relyingPartyRegistrationId, String id) {
        Assert.hasText((String)samlRequest, (String)"samlRequest cannot be null or empty");
        Assert.hasText((String)authenticationRequestUri, (String)"authenticationRequestUri cannot be null or empty");
        this.authenticationRequestUri = authenticationRequestUri;
        this.samlRequest = samlRequest;
        this.relayState = relayState;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
        this.id = id;
    }

    public String getSamlRequest() {
        return this.samlRequest;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getAuthenticationRequestUri() {
        return this.authenticationRequestUri;
    }

    public String getRelyingPartyRegistrationId() {
        return this.relyingPartyRegistrationId;
    }

    public String getId() {
        return this.id;
    }

    public abstract Saml2MessageBinding getBinding();

    public static class Builder<T extends Builder<T>> {
        String authenticationRequestUri;
        String samlRequest;
        String relayState;
        String relyingPartyRegistrationId;
        String id;

        @Deprecated
        protected Builder() {
        }

        protected Builder(RelyingPartyRegistration registration) {
            this.relyingPartyRegistrationId = registration.getRegistrationId();
        }

        protected final T _this() {
            return (T)this;
        }

        public T relayState(String relayState) {
            this.relayState = relayState;
            return this._this();
        }

        public T samlRequest(String samlRequest) {
            this.samlRequest = samlRequest;
            return this._this();
        }

        public T authenticationRequestUri(String authenticationRequestUri) {
            this.authenticationRequestUri = authenticationRequestUri;
            return this._this();
        }

        public T id(String id) {
            Assert.notNull((Object)id, (String)"id cannot be null");
            this.id = id;
            return this._this();
        }
    }
}

