/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.BaseOpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml5Template;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OpenSaml5AuthenticationProvider
implements AuthenticationProvider {
    private final BaseOpenSamlAuthenticationProvider delegate = new BaseOpenSamlAuthenticationProvider(new OpenSaml5Template());

    public OpenSaml5AuthenticationProvider() {
        this.setAssertionValidator(OpenSaml5AuthenticationProvider.createDefaultAssertionValidator());
    }

    public void setResponseElementsDecrypter(Consumer<ResponseToken> responseElementsDecrypter) {
        Assert.notNull(responseElementsDecrypter, (String)"responseElementsDecrypter cannot be null");
        this.delegate.setResponseElementsDecrypter((BaseOpenSamlAuthenticationProvider.ResponseToken token) -> responseElementsDecrypter.accept(new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token)));
    }

    public void setResponseValidator(Converter<ResponseToken, Saml2ResponseValidatorResult> responseValidator) {
        Assert.notNull(responseValidator, (String)"responseValidator cannot be null");
        this.delegate.setResponseValidator((Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2ResponseValidatorResult>)((Converter)token -> (Saml2ResponseValidatorResult)responseValidator.convert((Object)new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token))));
    }

    public void setAssertionValidator(Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator) {
        Assert.notNull(assertionValidator, (String)"assertionValidator cannot be null");
        this.delegate.setAssertionValidator((Converter<BaseOpenSamlAuthenticationProvider.AssertionToken, Saml2ResponseValidatorResult>)((Converter)token -> (Saml2ResponseValidatorResult)assertionValidator.convert((Object)new AssertionToken((BaseOpenSamlAuthenticationProvider.AssertionToken)token))));
    }

    public void setAssertionElementsDecrypter(Consumer<AssertionToken> assertionDecrypter) {
        Assert.notNull(assertionDecrypter, (String)"assertionDecrypter cannot be null");
        this.delegate.setAssertionElementsDecrypter((BaseOpenSamlAuthenticationProvider.AssertionToken token) -> assertionDecrypter.accept(new AssertionToken((BaseOpenSamlAuthenticationProvider.AssertionToken)token)));
    }

    public void setResponseAuthenticationConverter(Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter) {
        Assert.notNull(responseAuthenticationConverter, (String)"responseAuthenticationConverter cannot be null");
        this.delegate.setResponseAuthenticationConverter((Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, ? extends AbstractAuthenticationToken>)((Converter)token -> (AbstractAuthenticationToken)responseAuthenticationConverter.convert((Object)new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token))));
    }

    public static Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseValidator() {
        Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2ResponseValidatorResult> delegate = BaseOpenSamlAuthenticationProvider.createDefaultResponseValidator();
        return token -> (Saml2ResponseValidatorResult)delegate.convert((Object)new BaseOpenSamlAuthenticationProvider.ResponseToken(token.getResponse(), token.getToken()));
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator() {
        return OpenSaml5AuthenticationProvider.createDefaultAssertionValidatorWithParameters(params -> params.put("saml2.ClockSkew", Duration.ofMinutes(5L)));
    }

    @Deprecated
    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(Converter<AssertionToken, ValidationContext> contextConverter) {
        return OpenSaml5AuthenticationProvider.createAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> BaseOpenSamlAuthenticationProvider.SAML20AssertionValidators.attributeValidator), contextConverter);
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidatorWithParameters(Consumer<Map<String, Object>> validationContextParameters) {
        return OpenSaml5AuthenticationProvider.createAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> BaseOpenSamlAuthenticationProvider.SAML20AssertionValidators.attributeValidator), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> OpenSaml5AuthenticationProvider.createValidationContext(assertionToken, validationContextParameters)));
    }

    public static Converter<ResponseToken, Saml2Authentication> createDefaultResponseAuthenticationConverter() {
        Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2Authentication> delegate = BaseOpenSamlAuthenticationProvider.createDefaultResponseAuthenticationConverter();
        return token -> (Saml2Authentication)((Object)((Object)delegate.convert((Object)new BaseOpenSamlAuthenticationProvider.ResponseToken(token.getResponse(), token.getToken()))));
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    private static Converter<AssertionToken, Saml2ResponseValidatorResult> createAssertionValidator(String errorCode, Converter<AssertionToken, SAML20AssertionValidator> validatorConverter, Converter<AssertionToken, ValidationContext> contextConverter) {
        return assertionToken -> {
            Assertion assertion = assertionToken.getAssertion();
            SAML20AssertionValidator validator = (SAML20AssertionValidator)validatorConverter.convert(assertionToken);
            ValidationContext context = (ValidationContext)contextConverter.convert(assertionToken);
            try {
                ValidationResult result = validator.validate(assertion, context);
                if (result == ValidationResult.VALID) {
                    return Saml2ResponseValidatorResult.success();
                }
            }
            catch (Exception ex) {
                String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), ex.getMessage());
                return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
            }
            String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), context.getValidationFailureMessages());
            return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
        };
    }

    private static ValidationContext createValidationContext(AssertionToken assertionToken, Consumer<Map<String, Object>> paramsConsumer) {
        Saml2AuthenticationToken token = assertionToken.getToken();
        RelyingPartyRegistration relyingPartyRegistration = token.getRelyingPartyRegistration();
        String audience = relyingPartyRegistration.getEntityId();
        String recipient = relyingPartyRegistration.getAssertionConsumerServiceLocation();
        String assertingPartyEntityId = relyingPartyRegistration.getAssertingPartyMetadata().getEntityId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Assertion assertion = assertionToken.getAssertion();
        if (OpenSaml5AuthenticationProvider.assertionContainsInResponseTo(assertion)) {
            String requestId = OpenSaml5AuthenticationProvider.getAuthnRequestId(token.getAuthenticationRequest());
            params.put("saml2.SubjectConfirmation.ValidInResponseTo", requestId);
        }
        params.put("saml2.Conditions.ValidAudiences", Collections.singleton(audience));
        params.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(recipient));
        params.put("saml2.ValidIssuers", Collections.singleton(assertingPartyEntityId));
        paramsConsumer.accept(params);
        return new ValidationContext(params);
    }

    private static boolean assertionContainsInResponseTo(Assertion assertion) {
        if (assertion.getSubject() == null) {
            return false;
        }
        for (SubjectConfirmation confirmation : assertion.getSubject().getSubjectConfirmations()) {
            SubjectConfirmationData confirmationData = confirmation.getSubjectConfirmationData();
            if (confirmationData == null || !StringUtils.hasText((String)confirmationData.getInResponseTo())) continue;
            return true;
        }
        return false;
    }

    private static String getAuthnRequestId(AbstractSaml2AuthenticationRequest serialized) {
        return serialized != null ? serialized.getId() : null;
    }

    public static class AssertionToken {
        private final Saml2AuthenticationToken token;
        private final Assertion assertion;

        AssertionToken(Assertion assertion, Saml2AuthenticationToken token) {
            this.token = token;
            this.assertion = assertion;
        }

        AssertionToken(BaseOpenSamlAuthenticationProvider.AssertionToken token) {
            this.token = token.getToken();
            this.assertion = token.getAssertion();
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static class ResponseToken {
        private final Saml2AuthenticationToken token;
        private final Response response;

        ResponseToken(Response response, Saml2AuthenticationToken token) {
            this.token = token;
            this.response = response;
        }

        ResponseToken(BaseOpenSamlAuthenticationProvider.ResponseToken token) {
            this.token = token.getToken();
            this.response = token.getResponse();
        }

        public Response getResponse() {
            return this.response;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }
}

