/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.util.function.Consumer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.BaseOpenSamlLogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml5Template;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.util.Assert;

public final class OpenSaml5LogoutResponseResolver
implements Saml2LogoutResponseResolver {
    private final BaseOpenSamlLogoutResponseResolver delegate;

    public OpenSaml5LogoutResponseResolver(RelyingPartyRegistrationRepository registrations) {
        this.delegate = new BaseOpenSamlLogoutResponseResolver(registrations, (request, id) -> {
            if (id == null) {
                return null;
            }
            return registrations.findByRegistrationId(id);
        }, new OpenSaml5Template());
    }

    public OpenSaml5LogoutResponseResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.delegate = new BaseOpenSamlLogoutResponseResolver(null, relyingPartyRegistrationResolver, new OpenSaml5Template());
    }

    @Override
    public Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication) {
        return this.delegate.resolve(request, authentication);
    }

    public void setParametersConsumer(Consumer<LogoutResponseParameters> parametersConsumer) {
        Assert.notNull(parametersConsumer, (String)"parametersConsumer cannot be null");
        this.delegate.setParametersConsumer((BaseOpenSamlLogoutResponseResolver.LogoutResponseParameters parameters) -> parametersConsumer.accept(new LogoutResponseParameters((BaseOpenSamlLogoutResponseResolver.LogoutResponseParameters)parameters)));
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock must not be null");
        this.delegate.setClock(clock);
    }

    public static final class LogoutResponseParameters {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final Authentication authentication;
        private final LogoutRequest logoutRequest;

        public LogoutResponseParameters(HttpServletRequest request, RelyingPartyRegistration registration, Authentication authentication, LogoutRequest logoutRequest) {
            this.request = request;
            this.registration = registration;
            this.authentication = authentication;
            this.logoutRequest = logoutRequest;
        }

        LogoutResponseParameters(BaseOpenSamlLogoutResponseResolver.LogoutResponseParameters parameters) {
            this(parameters.getRequest(), parameters.getRelyingPartyRegistration(), parameters.getAuthentication(), parameters.getLogoutRequest());
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public LogoutRequest getLogoutRequest() {
            return this.logoutRequest;
        }
    }
}

