/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.springframework.security.saml2.Saml2Exception;

final class Saml2Utils {
    private Saml2Utils() {
    }

    static String samlEncode(byte[] b) {
        return Base64.getEncoder().encodeToString(b);
    }

    static byte[] samlDecode(String s) {
        return Base64.getMimeDecoder().decode(s);
    }

    static byte[] samlDeflate(String s) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)b, new Deflater(8, true));
            deflater.write(s.getBytes(StandardCharsets.UTF_8));
            deflater.finish();
            return b.toByteArray();
        }
        catch (IOException ex) {
            throw new Saml2Exception("Unable to deflate string", ex);
        }
    }

    static String samlInflate(byte[] b) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InflaterOutputStream iout = new InflaterOutputStream(out, new Inflater(true));
            iout.write(b);
            iout.finish();
            return new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new Saml2Exception("Unable to inflate string", ex);
        }
    }

    static EncodingConfigurer withDecoded(String decoded) {
        return new EncodingConfigurer(decoded);
    }

    static DecodingConfigurer withEncoded(String encoded) {
        return new DecodingConfigurer(encoded);
    }

    static final class EncodingConfigurer {
        private final String decoded;
        private boolean deflate;

        private EncodingConfigurer(String decoded) {
            this.decoded = decoded;
        }

        EncodingConfigurer deflate(boolean deflate) {
            this.deflate = deflate;
            return this;
        }

        String encode() {
            byte[] bytes = this.deflate ? Saml2Utils.samlDeflate(this.decoded) : this.decoded.getBytes(StandardCharsets.UTF_8);
            return Saml2Utils.samlEncode(bytes);
        }
    }

    static final class DecodingConfigurer {
        private static final Base64Checker BASE_64_CHECKER = new Base64Checker();
        private final String encoded;
        private boolean inflate;
        private boolean requireBase64;

        private DecodingConfigurer(String encoded) {
            this.encoded = encoded;
        }

        DecodingConfigurer inflate(boolean inflate) {
            this.inflate = inflate;
            return this;
        }

        DecodingConfigurer requireBase64(boolean requireBase64) {
            this.requireBase64 = requireBase64;
            return this;
        }

        String decode() {
            if (this.requireBase64) {
                BASE_64_CHECKER.checkAcceptable(this.encoded);
            }
            byte[] bytes = Saml2Utils.samlDecode(this.encoded);
            return this.inflate ? Saml2Utils.samlInflate(bytes) : new String(bytes, StandardCharsets.UTF_8);
        }

        static class Base64Checker {
            private static final int[] values = Base64Checker.genValueMapping();

            Base64Checker() {
            }

            private static int[] genValueMapping() {
                byte[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.ISO_8859_1);
                int[] values = new int[256];
                Arrays.fill(values, -1);
                for (int i = 0; i < alphabet.length; ++i) {
                    values[alphabet[i] & 0xFF] = i;
                }
                return values;
            }

            boolean isAcceptable(String s) {
                int goodChars = 0;
                int lastGoodCharVal = -1;
                for (int i = 0; i < s.length(); ++i) {
                    int val = values[0xFF & s.charAt(i)];
                    if (val == -1) continue;
                    lastGoodCharVal = val;
                    ++goodChars;
                }
                switch (goodChars % 4) {
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return (lastGoodCharVal & 0xF) == 0;
                    }
                    case 3: {
                        return (lastGoodCharVal & 3) == 0;
                    }
                }
                return false;
            }

            void checkAcceptable(String ins) {
                if (!this.isAcceptable(ins)) {
                    throw new IllegalArgumentException("Failed to decode SAMLResponse");
                }
            }
        }
    }
}

